/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.message_format;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.SpannableStringBuilder;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.message_format.message.BoldMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.EmojiMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.EscapeMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.GiantEmojiMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.ItalicMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.LinkMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.MentionMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.MessagePattern;
import com.zoyi.channel.plugin.android.util.message_format.message.UnescapeMessage;
import java.util.ArrayList;
import java.util.List;

public class MessageParser {
    private final String ESCAPE_SEQUENCE = "```";
    private List<MessagePattern> patterns = new ArrayList<MessagePattern>();
    private int linkColor;

    @Nullable
    public static MessageParser get() {
        if (ChannelIO.getAppContext() == null) {
            return null;
        }
        return LazyMessageParser.INSTANCE;
    }

    public static MessageParser get(Context context) {
        return new MessageParser(context);
    }

    private MessageParser(@Nullable Context context) {
        this.linkColor = context != null ? ContextCompat.getColor((Context)context, (int)R.color.ch_cobalt) : Color.parseColor((String)"#00a6ff");
        this.patterns.add(new EscapeMessage());
        this.patterns.add(new BoldMessage());
        this.patterns.add(new ItalicMessage());
        this.patterns.add(new MentionMessage());
        if (context != null) {
            this.patterns.add(new EmojiMessage(context));
        }
        this.patterns.add(new LinkMessage(this.linkColor));
        this.patterns.add(new UnescapeMessage());
        this.patterns.add(new GiantEmojiMessage());
    }

    @NonNull
    public SpannableStringBuilder parse(@Nullable String message) {
        SpannableStringBuilder resultMessage = new SpannableStringBuilder();
        if (message == null) {
            return resultMessage;
        }
        String[] tokens = message.split("```", -1);
        for (int index = 0; index < tokens.length; ++index) {
            SpannableStringBuilder parsedToken = this.parseString(tokens[index]);
            if (index % 2 == 0) {
                resultMessage.append((CharSequence)parsedToken);
                continue;
            }
            if (index == tokens.length - 1) {
                resultMessage.append((CharSequence)"```");
                resultMessage.append((CharSequence)parsedToken);
                continue;
            }
            resultMessage.append((CharSequence)tokens[index]);
        }
        return resultMessage;
    }

    public SpannableStringBuilder parseString(String message) {
        SpannableStringBuilder spannableString = new SpannableStringBuilder((CharSequence)message);
        for (MessagePattern messagePattern : this.patterns) {
            spannableString = messagePattern.parse(spannableString);
        }
        return spannableString;
    }

    private static class LazyMessageParser {
        private static final MessageParser INSTANCE = new MessageParser(ChannelIO.getAppContext());

        private LazyMessageParser() {
        }
    }
}

