/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat3.viewholder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.activity.chat3.listener.OnProfileUpdateRequestListener;
import com.zoyi.channel.plugin.android.activity.chat3.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat3.view.ProfileBotCompleteView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.ProfileBot;
import com.zoyi.channel.plugin.android.store2.GuestStore;
import com.zoyi.channel.plugin.android.store2.PluginStore;
import com.zoyi.channel.plugin.android.store2.ProfileBotStore;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.NumberUtils;
import com.zoyi.channel.plugin.android.util.ProfileUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import java.util.Locale;

public class ProfileBotMessageHolder
extends RecyclerView.ViewHolder {
    private LinearLayout layoutCompleteItems;
    private View viewProfileBotInput;
    private TextView inputLabel;
    private TextView textPage;
    private TextView textTotalPages;
    private View layoutInput;
    private View buttonSelectCountry;
    private TextView textCountry;
    private WatchedEditText editValue;
    private View inputProgress;
    private ImageButton buttonSubmit;
    private TextView textTerms;
    @Nullable
    private ProfileBotMessageItem item;
    @Nullable
    private ProfileBot activeProfileBot;
    @Nullable
    private OnProfileUpdateRequestListener listener;

    public ProfileBotMessageHolder(@NonNull View itemView, @Nullable OnProfileUpdateRequestListener listener) {
        super(itemView);
        this.listener = listener;
        this.layoutCompleteItems = (LinearLayout)itemView.findViewById(R.id.layoutProfileBotItemCompleteItems);
        this.viewProfileBotInput = itemView.findViewById(R.id.viewProfileBotItemInput);
        this.inputLabel = (TextView)itemView.findViewById(R.id.textProfileBotItemLabel);
        this.textPage = (TextView)itemView.findViewById(R.id.textProfileBotItemPage);
        this.textTotalPages = (TextView)itemView.findViewById(R.id.textProfileBotItemTotalPages);
        this.layoutInput = itemView.findViewById(R.id.layoutProfileBotInput);
        this.buttonSelectCountry = itemView.findViewById(R.id.buttonProfileBotItemSelectCountry);
        this.buttonSelectCountry.setOnClickListener(v -> {
            if (listener != null && this.item != null) {
                listener.onCountrySelectorClick(this.item);
            }
        });
        this.textCountry = (TextView)itemView.findViewById(R.id.textProfileBotItemSelectCountry);
        this.editValue = (WatchedEditText)itemView.findViewById(R.id.editProfileBotItem);
        this.editValue.setOnFocusChangeListener((v, hasFocus) -> {
            if (ProfileBotStore.get().requestState.get() == FetchState.COMPLETE) {
                if (hasFocus) {
                    this.layoutInput.setBackgroundResource(R.drawable.ch_plugin_profile_message_input);
                } else {
                    this.layoutInput.setBackgroundResource(R.drawable.ch_plugin_profile_message_input_out_focus);
                }
            }
            if (ProfileBotStore.get().requestState.get() != FetchState.LOADING) {
                ProfileBotStore.get().requestFocus.set(hasFocus);
            }
        });
        this.editValue.setWatchedTextChangedListener(s -> {
            if (this.activeProfileBot != null) {
                if ("mobileNumber".equals(this.activeProfileBot.getKey())) {
                    Object restoreData = ProfileBotStore.get().inputValue.get();
                    if (restoreData instanceof MobileNumber) {
                        ((MobileNumber)restoreData).setPhoneNumber(s);
                        ProfileBotStore.get().inputValue.set(restoreData);
                    }
                } else {
                    ProfileBotStore.get().inputValue.set(s);
                }
                ProfileBotStore.get().requestState.set(FetchState.COMPLETE);
                this.setLayoutStyle(this.activeProfileBot, FetchState.COMPLETE);
            }
        });
        this.inputProgress = itemView.findViewById(R.id.viewProfileBotItemProgress);
        this.buttonSubmit = (ImageButton)itemView.findViewById(R.id.buttonProfileBotItemSubmit);
        this.buttonSubmit.setOnClickListener(v -> {
            if (listener != null && this.item != null) {
                listener.onProfileRequest(this.item);
            }
        });
        this.textTerms = (TextView)itemView.findViewById(R.id.textProfileBotItemTerms);
        this.textTerms.setText((CharSequence)Utils.getHtmlFormattedText(ResUtils.getString("ch.agreement")));
        this.textTerms.setOnClickListener(v -> {
            Plugin plugin = PluginStore.get().pluginState.get();
            CHLocale locale = (CHLocale)((Object)((Object)SettingsStore.get().locale.get()));
            if (plugin != null && plugin.getKey() != null) {
                IntentUtils.setUrl(itemView.getContext(), String.format("https://channel.io/%s/terms_user?plugin_key=%s", locale.toString(), plugin.getKey())).startActivity();
            } else {
                IntentUtils.setUrl(itemView.getContext(), String.format("https://channel.io/%s/terms_user", locale.toString())).startActivity();
            }
        });
    }

    private void setLayoutStyle(ProfileBot profileBot, FetchState fetchState) {
        if (profileBot == null) {
            return;
        }
        switch (fetchState) {
            case LOADING: {
                this.inputLabel.setText((CharSequence)profileBot.getNameI18n().get(((CHLocale)((Object)SettingsStore.get().locale.get())).toString()));
                this.inputLabel.setTextColor(ResUtils.getColor(R.color.ch_light));
                this.editValue.setEnabled(false);
                this.inputProgress.setVisibility(0);
                this.buttonSubmit.setVisibility(8);
                this.layoutInput.setBackgroundResource(R.drawable.ch_plugin_profile_message_input_out_focus);
                break;
            }
            case FAILED: {
                this.inputLabel.setText((CharSequence)ResUtils.getString("ch.profile_form.error"));
                this.inputLabel.setTextColor(ResUtils.getColor(R.color.ch_orange));
                this.editValue.setEnabled(true);
                this.inputProgress.setVisibility(8);
                this.buttonSubmit.setVisibility(0);
                this.buttonSubmit.setImageResource(R.drawable.ch_send_error);
                this.layoutInput.setBackgroundResource(R.drawable.ch_plugin_profile_message_input_wrong);
                break;
            }
            case COMPLETE: {
                this.inputLabel.setText((CharSequence)profileBot.getNameI18n().get(((CHLocale)((Object)SettingsStore.get().locale.get())).toString()));
                this.inputLabel.setTextColor(ResUtils.getColor(R.color.ch_light));
                this.editValue.setEnabled(true);
                this.inputProgress.setVisibility(8);
                this.buttonSubmit.setVisibility(0);
                this.buttonSubmit.setImageResource(R.drawable.ch_send);
                if (this.editValue.isFocused()) {
                    this.layoutInput.setBackgroundResource(R.drawable.ch_plugin_profile_message_input);
                    break;
                }
                this.layoutInput.setBackgroundResource(R.drawable.ch_plugin_profile_message_input_out_focus);
            }
        }
    }

    public void bind(ProfileBotMessageItem item) {
        this.item = item;
        if (item == null) {
            return;
        }
        int selectedIndex = -1;
        for (int i = 0; i < item.getProfileBots().size(); ++i) {
            ProfileBot profileBot = item.getProfileBots().get(i);
            if (profileBot == null || profileBot.getKey() == null) continue;
            if (profileBot.getValue() != null) {
                Object view;
                if (i < this.layoutCompleteItems.getChildCount()) {
                    view = this.layoutCompleteItems.getChildAt(i);
                    if (!(view instanceof ProfileBotCompleteView)) continue;
                    view.setVisibility(0);
                    ((ProfileBotCompleteView)((Object)view)).bind(profileBot);
                    continue;
                }
                view = new ProfileBotCompleteView(this.itemView.getContext());
                ((ProfileBotCompleteView)((Object)view)).bind(profileBot);
                this.layoutCompleteItems.addView((View)view);
                continue;
            }
            selectedIndex = i;
            if (this.viewProfileBotInput.getVisibility() == 8) {
                this.viewProfileBotInput.setVisibility(0);
            }
            this.activeProfileBot = profileBot;
            this.textPage.setText((CharSequence)String.valueOf(i + 1));
            this.textTotalPages.setText((CharSequence)String.format(Locale.US, "/%d", item.getProfileBots().size()));
            String prevKey = ProfileBotStore.get().inputKey.get();
            if (prevKey == null || profileBot.getKey().equals(prevKey)) {
                this.setLayoutStyle(profileBot, (FetchState)((Object)ProfileBotStore.get().requestState.get()));
            }
            ProfileBotStore.get().inputKey.set(profileBot.getKey());
            if ("mobileNumber".equals(profileBot.getKey())) {
                this.setMobileNumberInput();
            } else if ("Number".equals(profileBot.getType())) {
                this.setNumericInput(profileBot.getKey());
            } else {
                this.setStringInput(profileBot.getKey());
            }
            int index = i;
            while (i < this.layoutCompleteItems.getChildCount()) {
                this.layoutCompleteItems.getChildAt(index).setVisibility(8);
                ++i;
            }
            break;
        }
        this.textTerms.setVisibility(selectedIndex == 0 ? 0 : 8);
        if (selectedIndex == -1) {
            this.activeProfileBot = null;
            this.viewProfileBotInput.setVisibility(8);
            if (ProfileBotStore.get().requestFocus.get().booleanValue()) {
                ProfileBotStore.get().requestFocus.set(false);
                if (this.listener != null) {
                    this.listener.onProfileUpdateComplete();
                }
            }
        } else if (ProfileBotStore.get().requestFocus.get().booleanValue() && ProfileBotStore.get().requestState.get() != FetchState.LOADING) {
            this.editValue.requestFocus();
            InputMethodManager imm = (InputMethodManager)this.itemView.getContext().getSystemService("input_method");
            imm.toggleSoftInput(2, 0);
        }
    }

    @NonNull
    private String restoreStringData(String key) {
        Guest guest = GuestStore.get().guest.get();
        if (guest != null) {
            return ProfileUtils.getFormattedString(guest.getProfileValue(key));
        }
        return "";
    }

    @NonNull
    private MobileNumber restoreMobileNumberData() {
        Object profileValue;
        Guest guest = GuestStore.get().guest.get();
        if (guest != null && (profileValue = guest.getProfileValue("mobileNumber")) instanceof String) {
            return new MobileNumber(String.valueOf(profileValue));
        }
        return new MobileNumber();
    }

    private void setNumericInput(String key) {
        this.editValue.setInputType(8194);
        Object savedData = ProfileBotStore.get().inputValue.get();
        if (savedData instanceof String) {
            this.setTextKeepSelection((String)savedData);
        } else {
            String restoreData = this.restoreStringData(key);
            ProfileBotStore.get().inputValue.set(restoreData);
            this.setTextWithBlock(restoreData);
        }
        this.buttonSelectCountry.setVisibility(8);
    }

    private void setStringInput(String key) {
        this.editValue.setInputType(1);
        Object savedData = ProfileBotStore.get().inputValue.get();
        if (savedData instanceof String) {
            this.setTextKeepSelection((String)savedData);
        } else {
            String restoreData = this.restoreStringData(key);
            ProfileBotStore.get().inputValue.set(restoreData);
            this.setTextWithBlock(restoreData);
        }
        this.buttonSelectCountry.setVisibility(8);
    }

    private void setMobileNumberInput() {
        this.editValue.setInputType(8194);
        Object savedData = ProfileBotStore.get().inputValue.get();
        if (savedData instanceof MobileNumber) {
            this.textCountry.setText((CharSequence)String.format("+%s", ((MobileNumber)savedData).getCountryCode()));
            this.setTextKeepSelection(((MobileNumber)savedData).getPhoneNumber());
        } else {
            MobileNumber restoreData = this.restoreMobileNumberData();
            ProfileBotStore.get().inputValue.set(restoreData);
            this.textCountry.setText((CharSequence)String.format("+%s", restoreData.getCountryCode()));
            this.setTextWithBlock(restoreData.getPhoneNumber());
        }
        this.buttonSelectCountry.setVisibility(0);
    }

    private void setTextKeepSelection(String value) {
        int selectionStart = NumberUtils.bewteen(this.editValue.getSelectionStart(), 0, value.length());
        int selectionEnd = NumberUtils.bewteen(this.editValue.getSelectionEnd(), 0, value.length());
        this.editValue.setTextWithBlock(value);
        this.editValue.setSelection(selectionStart, selectionEnd);
        this.editValue.setBlock(false);
    }

    private void setTextWithBlock(String value) {
        this.editValue.setTextWithBlock(value);
        this.editValue.selectAll();
        this.editValue.setBlock(false);
    }

    public static ProfileBotMessageHolder newInstance(ViewGroup parent, @Nullable OnProfileUpdateRequestListener listener) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        return new ProfileBotMessageHolder(inflater.inflate(R.layout.ch_plugin_item_message_profile_bot, parent, false), listener);
    }
}

