/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.action;

import android.support.annotation.NonNull;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.wrapper.ChannelWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessengersRepo;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store2.ChannelStore;

public class ChannelAction {
    public static void fetchChannel() {
        ChannelStore.get().channelFetchState.set(FetchState.LOADING);
        Api.getChannel().runBy(ActionType.REQUEST_CHANNEL).cancelBy(ActionType.SOCKET_DISCONNECTED, ActionType.MESSENGER_CLOSED, ActionType.SHUTDOWN).run(new RestSubscriber<ChannelWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                ChannelStore.get().channelFetchState.set(FetchState.FAILED);
            }

            @Override
            public void onSuccess(@NonNull ChannelWrapper channelWrapper) {
                if (channelWrapper.getChannel() != null) {
                    ChannelStore.get().channelState.set(channelWrapper.getChannel());
                }
                ChannelStore.get().channelFetchState.set(FetchState.COMPLETE);
            }
        });
    }

    public static void fetchMessengers() {
        ChannelStore.get().messengersFetchState.set(FetchState.LOADING);
        Api.getMessengers().runBy(ActionType.REQUEST_MESSENGERS).cancelBy(ActionType.SOCKET_DISCONNECTED, ActionType.MESSENGER_CLOSED, ActionType.SHUTDOWN).run(new RestSubscriber<MessengersRepo>(){

            @Override
            public void onError(RetrofitException error) {
                ChannelStore.get().messengersFetchState.set(FetchState.FAILED);
            }

            @Override
            public void onSuccess(@NonNull MessengersRepo repo) {
                ChannelStore.get().messengers.set(repo);
                ChannelStore.get().messengersFetchState.set(FetchState.COMPLETE);
            }
        });
    }
}

