package com.zoyi.channel.plugin.android.util.message_format.message;

import android.graphics.Typeface;
import android.support.v4.util.Pair;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;

import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RegexUtils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class ItalicMessage implements MessagePattern {

  private Pattern italicPattern = Pattern.compile("(\\*)(.+?)\\1");

  @Override
  public SpannableStringBuilder parse(SpannableStringBuilder span) {

    for (Pair<Integer, Integer> range : RegexUtils.getReversedRange(italicPattern.matcher(span))) {
      int start = range.first;
      int end = range.second;

      span.delete(end - 1, end);
      span.delete(start, start + 1);
      span.setSpan(new StyleSpan(Typeface.ITALIC), start, end - 2, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
    }

    return span;
  }
}

