package com.zoyi.channel.plugin.android.selector2;

import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.store2.ChatStore;
import com.zoyi.channel.plugin.android.util.CompareUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ImageSelector {

  public static List<File> getImageFiles() {
    List<File> files = new ArrayList<>();

    for (Message message : ChatStore.get().messages.get().values()) {
      if (message != null && message.getFile() != null && message.getFile().isImageFile()) {
        files.add(message.getFile());
      }
    }

    Collections.sort(files, (o1, o2) -> CompareUtils.compare(o1.getId(), o2.getId()));

    return files;
  }
}
