package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.content.Context;
import com.zoyi.channel.plugin.android.activity.photo_picker.contract.PhotoPickerAdapterContract;
import com.zoyi.channel.plugin.android.activity.photo_picker.contract.PhotoPickerContract;
import com.zoyi.channel.plugin.android.base.AbstractAdapterPresenter;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoDataSource;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoRepository;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.rx.Subscriber;

import java.util.ArrayList;

public class PhotoPickerPresenter
    extends AbstractAdapterPresenter<PhotoPickerContract.View, PhotoPickerAdapterContract.View, PhotoPickerAdapterContract.Model>
    implements PhotoPickerContract.Presenter, OnPhotoClickListener {

  private Context context;

  private PhotoRepository photoRepository;

  @Initializer
  public PhotoPickerPresenter(
      Context context,
      PhotoPickerContract.View view,
      PhotoPickerAdapterContract.View adapterView,
      PhotoPickerAdapterContract.Model adapterModel
  ) {
    super(view, adapterView, adapterModel);

    adapterView.setOnPhotoClickListener(this);
    this.context = context;
  }

  @Initializer
  @Override
  public void init() {
    photoRepository = new PhotoRepository(new PhotoDataSource());
  }

  @Override
  public void fetchPhotoItems() {
    photoRepository.getPhotoItems(context, new Subscriber<ArrayList<PhotoItem>>() {
      @Override
      public void onCompleted() {
      }

      @Override
      public void onError(Throwable throwable) {
        view.loadPhotoItems(new ArrayList<>());
      }

      @Override
      public void onNext(ArrayList<PhotoItem> photoItems) {
        view.loadPhotoItems(photoItems);

        adapterModel.setPhotoItems(photoItems);
        adapterModel.refreshSelectedItems();

        adapterView.notifyDataChanged();
      }
    });
  }

  @Override
  public void collectSelectedPhotoItem() {
    ArrayList<String> paths = adapterModel.getPhotoPaths();

    if (paths != null && paths.size() > 0) {
      view.sendPhotoPaths(adapterModel.getPhotoPaths());
    }
  }

  @Override
  public int onPhotoClick(int position, boolean checked) {
    int selectedCount = adapterModel.selectPhotoItem(position, checked);

    view.setMenuState(adapterModel.getSelectedItemCount());

    return selectedCount;
  }
}
