package com.zoyi.channel.plugin.android.activity.lounge.contract;

import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.lounge.enumerate.PreviewState;
import com.zoyi.channel.plugin.android.contract.BaseAdapterPresenter;
import com.zoyi.channel.plugin.android.contract.BaseView;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;

public interface LoungeContract {

  interface View extends BaseView {

    void onDefaultProfileChange(ProfileEntity profileEntity);

    void onWelcomeMessageChange(String message);

    void onPreviewStateChange(PreviewState previewState, int invisibleChatsCount);
  }

  interface Presenter extends BaseAdapterPresenter {

    void fetchBundleData();

    void fetchPreviewData();

    void removeChat(ChatItem item);
  }
}
