/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.selector2;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.PushBotChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.UserChatItem;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store2.BotStore;
import com.zoyi.channel.plugin.android.store2.ChannelStore;
import com.zoyi.channel.plugin.android.store2.ManagerStore;
import com.zoyi.channel.plugin.android.store2.PushBotStore;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.channel.plugin.android.store2.UserChatStore;
import com.zoyi.channel.plugin.android.store2.base.Store2;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.store2.binder.Binder1;
import com.zoyi.channel.plugin.android.store2.binder.Binder3;
import com.zoyi.channel.plugin.android.store2.binder.Binder8;
import com.zoyi.channel.plugin.android.store2.state.BooleanState;
import com.zoyi.channel.plugin.android.store2.state.EntityMapState;
import com.zoyi.channel.plugin.android.store2.state.MapState;
import com.zoyi.channel.plugin.android.store2.state.State;
import com.zoyi.channel.plugin.android.store2.state.UpdatableMapState;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;
import com.zoyi.rx.functions.Action3;
import java.util.ArrayList;
import java.util.List;

public class ChatsSelector {
    public static Binder bindChats(Action2<List<ChatItem>, List<ChatItem>> action2) {
        EntityMapState<PushBotItem> pushBotItemsState = PushBotStore.get().pushBots;
        EntityMapState<UserChat> userChatsState = UserChatStore.get().userChats;
        UpdatableMapState<String, Session> sessionsState = UserChatStore.get().sessions;
        MapState<String, Message> messagesState = UserChatStore.get().messages;
        EntityMapState<Manager> managersState = ManagerStore.get().managers;
        EntityMapState<Bot> botsState = BotStore.get().bots;
        State<String> defaultBotIdState = Store2.getInstance(BotStore.class).defaultBotId;
        BooleanState showClosedChatsState = SettingsStore.get().showClosedChat;
        return new Binder8(pushBotItemsState, userChatsState, sessionsState, messagesState, managersState, botsState, defaultBotIdState, showClosedChatsState).bind((pushBotItems, userChats, sessions, messages, managers, bots, defaultBotId, showClosedChat) -> {
            ArrayList<ChatItem> activeChatItems = new ArrayList<ChatItem>();
            ArrayList<UserChatItem> closedChatItems = new ArrayList<UserChatItem>();
            for (PushBotItem pushBotItem : pushBotItems.values()) {
                if (!pushBotItem.isActive()) continue;
                activeChatItems.add(new PushBotChatItem(pushBotItem));
            }
            for (UserChat userChat : userChats.values()) {
                if (userChat.isStateRemoved()) continue;
                Message message = (Message)messages.get(userChat.getId());
                Session session = (Session)sessions.get(userChat.getId());
                ProfileEntity profileEntity = null;
                if ("Manager".equals(userChat.getHostType())) {
                    profileEntity = (ProfileEntity)managers.get(userChat.getHostId());
                } else if ("Bot".equals(userChat.getHostType())) {
                    profileEntity = (ProfileEntity)bots.get(userChat.getHostId());
                }
                if (profileEntity == null && defaultBotId != null) {
                    profileEntity = (ProfileEntity)bots.get(defaultBotId);
                }
                UserChatItem newChatItem = new UserChatItem(userChat, message, session, profileEntity);
                if (showClosedChat.booleanValue() && userChat.isStateClosed()) {
                    closedChatItems.add(newChatItem);
                    continue;
                }
                if (userChat.isStateClosed()) continue;
                activeChatItems.add(newChatItem);
            }
            action2.call(activeChatItems, closedChatItems);
        });
    }

    public static Binder bindUserChatsFetchState(Action1<FetchState> action1) {
        return new Binder1<FetchState>(UserChatStore.get().userChatsFetchState).bind(action1);
    }

    public static Binder binderHost(@Nullable String chatId, Action2<ProfileEntity, Boolean> action2) {
        EntityMapState<UserChat> userChatsState = UserChatStore.get().userChats;
        EntityMapState<Manager> managersState = ManagerStore.get().managers;
        State<Channel> channelState = Store2.getInstance(ChannelStore.class).channelState;
        return new Binder3<UserChat, Manager, Channel>(userChatsState, managersState, channelState).bind((Action3<UserChat, Manager, Channel>)((Action3)(userChats, managers, channel) -> {
            Manager manager;
            UserChat userChat;
            UserChat userChat2 = userChat = chatId != null ? (UserChat)userChats.get(chatId) : null;
            if (userChat == null) {
                action2.call(channel, null);
                return;
            }
            Manager manager2 = manager = "Manager".equals(userChat.getHostType()) && userChat.getHostId() != null ? (Manager)managers.get(userChat.getHostId()) : null;
            if (manager != null) {
                action2.call((Object)manager, (Object)manager.getOnline());
            } else {
                action2.call(channel, null);
            }
        }));
    }
}

