/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerAdapter;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerPresenter;
import com.zoyi.channel.plugin.android.activity.photo_picker.contract.PhotoPickerContract;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.rxpermission.RxPermissions;
import java.util.ArrayList;

public class PhotoPickerActivity
extends BaseActivity2
implements PhotoPickerContract.View {
    private LinearLayout emptyLayout;
    private NavigationView navigation;
    private PhotoPickerContract.Presenter presenter;
    private RxPermissions rxPermissions;

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_photo_picker);
        this.rxPermissions = new RxPermissions((Activity)this);
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view_photo_picker);
        PhotoPickerAdapter adapter = new PhotoPickerAdapter((Context)this);
        this.presenter = new PhotoPickerPresenter((Context)this, this, adapter, adapter);
        this.emptyLayout = (LinearLayout)this.findViewById(R.id.no_album);
        this.navigation = (NavigationView)this.findViewById(R.id.navigationPhotoPicker);
        this.navigation.addAction(R.drawable.ch_plugin_ic_photo_camera_white_24dp, 24.0f, v -> this.openCamera());
        this.navigation.addAction(R.drawable.ch_plugin_ic_done_white_24dp, 24.0f, v -> this.presenter.collectSelectedPhotoItem());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, 3));
        recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        recyclerView.setItemAnimator(null);
        this.bindPresenter(this.presenter);
        return true;
    }

    protected void onStart() {
        super.onStart();
        this.fetchPhotoItems();
    }

    public void onBackPressed() {
        this.setResult(0);
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 3000: {
                    String photoPath = Executor.getPhotoPath();
                    if (!TextUtils.isEmpty((CharSequence)photoPath)) {
                        Executor.startFileMediaScan((Activity)this, photoPath);
                        this.sendPhotoPath(Executor.getPhotoPath());
                    }
                    return;
                }
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    private void sendPhotoPath(String photoPath) {
        ArrayList<String> photoPaths = new ArrayList<String>();
        photoPaths.add(photoPath);
        this.sendPhotoPaths(photoPaths);
    }

    @Override
    public void loadPhotoItems(ArrayList<PhotoItem> photoItems) {
        this.setEmptyLayoutVisibility(photoItems.isEmpty());
    }

    @Override
    public void sendPhotoPaths(ArrayList<String> imagePaths) {
        Intent i = new Intent();
        i.putStringArrayListExtra("PHOTO_INTENT_KEY", imagePaths);
        this.setResult(12, i);
        this.finish();
    }

    @Override
    public void setMenuState(int selectedCount) {
    }

    private void setEmptyLayoutVisibility(boolean visible) {
        this.emptyLayout.setVisibility(visible ? 0 : 8);
    }

    private void fetchPhotoItems() {
        this.rxPermissions.request("android.permission.WRITE_EXTERNAL_STORAGE").subscribe(granted -> {
            if (granted.booleanValue()) {
                this.fetchPhotoItemsPermissionAccepted();
            } else {
                this.showDeniedToast();
            }
        });
    }

    private void fetchPhotoItemsPermissionAccepted() {
        this.presenter.fetchPhotoItems();
    }

    private void openCamera() {
        if (!Utils.hasPermissionInManifest((Context)this, "android.permission.CAMERA")) {
            this.openCameraPermissionAccepted();
        } else {
            this.rxPermissions.request("android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA").subscribe(granted -> {
                if (granted.booleanValue()) {
                    this.openCameraPermissionAccepted();
                } else {
                    this.showDeniedToast();
                }
            });
        }
    }

    private void openCameraPermissionAccepted() {
        if (!Executor.takePhoto((Activity)this)) {
            this.showDeniedToast();
        }
    }

    private void showDeniedToast() {
        Toast.makeText((Context)this, (CharSequence)ResUtils.getString((Context)this, "ch.permission.denied"), (int)1).show();
    }
}

