/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Observer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.CompositeException;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnSubscribeDoOnEach<T>
implements Observable.OnSubscribe<T> {
    private final Observer<? super T> doOnEachObserver;
    private final Observable<T> source;

    public OnSubscribeDoOnEach(Observable<T> source, Observer<? super T> doOnEachObserver) {
        this.source = source;
        this.doOnEachObserver = doOnEachObserver;
    }

    @Override
    public void call(Subscriber<? super T> subscriber) {
        this.source.unsafeSubscribe(new DoOnEachSubscriber<T>(subscriber, this.doOnEachObserver));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DoOnEachSubscriber<T>
    extends Subscriber<T> {
        private final Subscriber<? super T> subscriber;
        private final Observer<? super T> doOnEachObserver;
        private boolean done;

        DoOnEachSubscriber(Subscriber<? super T> subscriber, Observer<? super T> doOnEachObserver) {
            super(subscriber);
            this.subscriber = subscriber;
            this.doOnEachObserver = doOnEachObserver;
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            try {
                this.doOnEachObserver.onCompleted();
            }
            catch (Throwable e) {
                Exceptions.throwOrReport(e, this);
                return;
            }
            this.done = true;
            this.subscriber.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaHooks.onError(e);
                return;
            }
            this.done = true;
            try {
                this.doOnEachObserver.onError(e);
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.subscriber.onError(new CompositeException(Arrays.asList(e, e2)));
                return;
            }
            this.subscriber.onError(e);
        }

        @Override
        public void onNext(T value) {
            if (this.done) {
                return;
            }
            try {
                this.doOnEachObserver.onNext(value);
            }
            catch (Throwable e) {
                Exceptions.throwOrReport(e, this, value);
                return;
            }
            this.subscriber.onNext(value);
        }
    }
}

