package com.zoyi.channel.plugin.android.view.textview;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.selector2.SettingsSelector;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;

public class CHTextView extends android.support.v7.widget.AppCompatTextView {

  private Context context;

  @Nullable
  private String textKey;

  private boolean isHtml;

  @Nullable
  private Binder binder;

  @Nullable
  private OnTextContentChangeListener onTextContentChangeListener;

  @Nullable
  private Object data;

  public CHTextView(Context context) {
    super(context);
    init(context, null);
  }

  public CHTextView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public CHTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @Initializer
  private void init(Context context, @Nullable AttributeSet attrs) {
    this.context = context;

    if (attrs != null) {
      TypedArray typedArray = getContext().obtainStyledAttributes(attrs, R.styleable.ChannelTextBasedView);
      try {
        textKey = typedArray.getString(R.styleable.ChannelTextBasedView_ch_tv_textKey);
        isHtml = typedArray.getBoolean(R.styleable.ChannelTextBasedView_ch_tv_isHtml, false);
      } finally {
        typedArray.recycle();
      }
    }
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    binder = SettingsSelector.bindLocale(locale -> setTextKey(locale, textKey, data));
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (binder != null) {
      binder.unbind();
      binder = null;
    }
  }

  public void setOnTextContentChangeListener(@Nullable OnTextContentChangeListener onTextContentChangeListener) {
    this.onTextContentChangeListener = onTextContentChangeListener;
  }

  public void setData(@Nullable Object data) {
    this.data = data;

    setTextKey(SettingsStore.get().locale.get(), textKey, data);
  }

  public void setTextKey(@Nullable String textKey) {
    this.textKey = textKey;

    setTextKey(SettingsStore.get().locale.get(), textKey, data);
  }

  private void setTextKey(CHLocale locale, @Nullable String textKey, @Nullable Object data) {
    if (textKey != null) {
      String content = ResUtils.getString(context, locale, textKey);

      if (onTextContentChangeListener != null) {
        setContent(onTextContentChangeListener.onTextContentChange(content, data));
      } else {
        setContent(content);
      }
    }
  }

  private void setContent(@Nullable String content) {
    if (isHtml && content != null) {
      setText(Utils.getHtmlFormattedText(content));
    } else {
      setText(content);
    }
  }
}
