package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.action.GuestAction;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store2.GlobalStore;
import com.zoyi.channel.plugin.android.store2.PluginStore;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.channel.plugin.android.util.L;

public class ActivityLifecycleManager implements Application.ActivityLifecycleCallbacks {

  private int running = 0;

  @Override
  public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
  }

  @Override
  public void onActivityStarted(Activity activity) {
    L.d("Started: " + activity.getClass().getSimpleName() + " " + running + " -> " + (running + 1));

    if (!ChannelUtils.isChannelPluginActivity(activity)) {
      FrameLayout root = activity.findViewById(R.id.channel_io_view);
      if (root == null) {
        root = new FrameLayout(activity);
        root.setClipChildren(false);
        root.setClipToPadding(false);
        root.setFitsSystemWindows(true);
        root.setId(R.id.channel_io_view);
        root.addView(new ChannelView(activity));

        activity.addContentView(root, new FrameLayout.LayoutParams(
            FrameLayout.LayoutParams.MATCH_PARENT,
            FrameLayout.LayoutParams.MATCH_PARENT));
      }
    }

    GlobalStore.get().topActivity.set(activity);

    if (++running == 1 && PluginStore.get().pluginState.get() != null) {
      SocketManager.connect();
    }
  }

  @Override
  public void onActivityResumed(Activity activity) {
  }

  @Override
  public void onActivityPaused(Activity activity) {
  }

  @Override
  public void onActivityStopped(Activity activity) {
    L.d("Stopped: " + activity.getClass().getSimpleName() + " " + running + " -> " + (running - 1));

    if (GlobalStore.get().topActivity.get() == activity) {
      GlobalStore.get().topActivity.set(null);
    }
    if (--running == 0) {
      SocketManager.disconnect();
    }
  }

  @Override
  public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
  }

  @Override
  public void onActivityDestroyed(Activity activity) {
  }
}
