/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.action;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store2.SupportBotStore;
import com.zoyi.channel.plugin.android.store2.base.Store2;

public class SupportBotAction {
    public static void fetchSupportBot(String pluginId, boolean handleLoadingState) {
        if (handleLoadingState) {
            Store2.getInstance(SupportBotStore.class).supportBotFetchState.set(FetchState.LOADING);
        }
        Api.getSupportBot(pluginId).runBy(ActionType.REQUEST_SUPPORT_BOT).cancelBy(ActionType.SOCKET_DISCONNECTED, ActionType.SHUTDOWN).run(new RestSubscriber<SupportBotEntry>(){

            @Override
            public void onError(RetrofitException error) {
                SupportBotStore.get().supportBotFetchState.set(FetchState.FAILED);
            }

            @Override
            public void onSuccess(@NonNull SupportBotEntry supportBotEntry) {
                if (supportBotEntry.getId() != null) {
                    SupportBotStore.get().supportBotState.set(supportBotEntry);
                } else {
                    SupportBotStore.get().supportBotState.set(null);
                }
                Store2.getInstance(SupportBotStore.class).supportBotFetchState.set(FetchState.COMPLETE);
            }
        });
    }

    public static void createSupportBotUserChat(@Nullable String supportBotId, RestSubscriber<UserChatWrapper> subscriber) {
        if (supportBotId != null) {
            Api.createSupportBotUserChat(supportBotId).runBy(ActionType.CREATE_USER_CHAT).cancelBy(ActionType.SHUTDOWN).run(subscriber);
        }
    }
}

