/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.socket;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.InAppPushItem;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Log;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.rest.Veil;
import com.zoyi.channel.plugin.android.store2.BotStore;
import com.zoyi.channel.plugin.android.store2.ChannelStore;
import com.zoyi.channel.plugin.android.store2.ChatStore;
import com.zoyi.channel.plugin.android.store2.GlobalStore;
import com.zoyi.channel.plugin.android.store2.GuestStore;
import com.zoyi.channel.plugin.android.store2.InAppPushStore;
import com.zoyi.channel.plugin.android.store2.ManagerStore;
import com.zoyi.channel.plugin.android.store2.SocketStore;
import com.zoyi.channel.plugin.android.store2.TypingStore;
import com.zoyi.channel.plugin.android.store2.UserChatStore;
import com.zoyi.channel.plugin.android.store2.base.Store2;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.io.socket.client.IO;
import com.zoyi.io.socket.client.Socket;
import com.zoyi.io.socket.client.SocketIOException;
import com.zoyi.io.socket.emitter.Emitter;
import com.zoyi.io.socket.engineio.client.EngineIOException;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.subjects.PublishSubject;
import java.net.URISyntaxException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class SocketManager {
    private static SocketManager socketManager;
    private Application application;
    private Socket socket;
    private Timer reconnectConsumer;
    private AtomicBoolean forceDisconnect;
    private AtomicBoolean ready;
    private AtomicBoolean error;
    private Subscription heartbeat;
    private BlockingQueue<Integer> reconnectQueue;
    private int[] attemptDelay = new int[]{5, 8, 13, 21, 34, 55, 89};
    private AtomicInteger attemptCount = new AtomicInteger();
    private static final int HEARTBEAT_INTERVAL = 30000;
    private static final int RECONNECT_POP_INTERVAL = 500;
    private static PublishSubject<String> chatJoinedPublishSubject;
    static String SOCKET_END_POINT;
    private String channelId;
    private Emitter.Listener onTyping = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onTyping: " + objects[0].toString());
            Typing typing = (Typing)SocketManager.this.parseJson(objects[0].toString(), Typing.class);
            if (typing != null) {
                typing.setCreatedAt(TimeUtils.getCurrentTime());
                if ("start".equals(typing.getAction())) {
                    TypingStore.get().hostTypingState.upsert(typing);
                } else if ("stop".equals(typing.getAction())) {
                    TypingStore.get().hostTypingState.remove(typing);
                }
            }
        }
    };
    private Emitter.Listener onConnect = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onConnect: ");
            try {
                SocketManager.this.error.set(false);
                SocketManager.this.forceDisconnect.set(false);
                SocketManager.this.attemptCount.set(0);
                SocketManager.this.authentication();
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
        }
    };
    private Emitter.Listener onConnectTimeout = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onConnectTimeout");
            SocketStore.get().socketState.set(SocketStatus.ERROR);
        }
    };
    private Emitter.Listener onConnectError = new Emitter.Listener(){

        public void call(Object ... objects) {
            SocketManager.this.ready.set(false);
            SocketManager.this.enqueueReconnect();
            SocketManager.this.error.set(true);
            SocketStore.get().socketState.set(SocketStatus.ERROR);
            try {
                EngineIOException exception;
                String message = "";
                if (objects[0] instanceof EngineIOException) {
                    exception = (EngineIOException)objects[0];
                    message = exception.getMessage();
                }
                if (objects[0] instanceof SocketIOException) {
                    exception = (SocketIOException)objects[0];
                    message = exception.getMessage();
                }
                L.e("onConnectError: " + message);
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
        }
    };
    private Emitter.Listener onConnecting = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onConnecting");
        }
    };
    private Emitter.Listener onDisconnect = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onDisconnect: " + objects[0] + " " + SocketManager.this.forceDisconnect.get());
            SocketManager.this.ready.set(false);
            SocketManager.this.stopHeartbeat();
            if (!SocketManager.this.forceDisconnect.get()) {
                SocketManager.this.enqueueReconnect();
                SocketStore.get().socketState.set(SocketStatus.ERROR);
            } else {
                SocketStore.get().socketState.set(SocketStatus.DISCONNECTED);
            }
            Action.invoke(ActionType.SOCKET_DISCONNECTED);
        }
    };
    private Emitter.Listener onError = new Emitter.Listener(){

        public void call(Object ... objects) {
            EngineIOException exception = (EngineIOException)objects[0];
            L.e("onError: " + objects.length + " " + exception.getMessage());
            SocketManager.this.error.set(true);
            SocketStore.get().socketState.set(SocketStatus.ERROR);
            SocketManager.this.ready.set(false);
            SocketManager.this.enqueueReconnect();
        }
    };
    private Emitter.Listener onPing = new Emitter.Listener(){

        public void call(Object ... objects) {
        }
    };
    private Emitter.Listener onPong = new Emitter.Listener(){

        public void call(Object ... objects) {
        }
    };
    private Emitter.Listener onReconnect = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onReconnect: " + (Integer)objects[0]);
        }
    };
    private Emitter.Listener onReconnectAttempt = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onReconnectAttempt: " + (Integer)objects[0]);
        }
    };
    private Emitter.Listener onReconnectError = new Emitter.Listener(){

        public void call(Object ... objects) {
            SocketIOException exception = (SocketIOException)objects[0];
            L.e("onReconnectError: " + exception.getMessage());
            SocketManager.this.enqueueReconnect();
            SocketManager.this.ready.set(false);
            SocketStore.get().socketState.set(SocketStatus.ERROR);
        }
    };
    private Emitter.Listener onReconnectFailed = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.e("onReconnectFailed");
            SocketManager.this.enqueueReconnect();
            SocketManager.this.ready.set(false);
            SocketStore.get().socketState.set(SocketStatus.ERROR);
        }
    };
    private Emitter.Listener onReconnecting = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onReconnecting: " + (Integer)objects[0]);
        }
    };
    private Emitter.Listener onAuthenticated = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onAuthenticated: " + objects[0]);
        }
    };
    private Emitter.Listener onReady = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("Ready");
            SocketManager.this.ready.set(true);
            SocketManager.this.startHeartbeat();
            SocketManager.this.clearReconnectQueue();
            SocketStore.get().socketState.set(SocketStatus.READY);
        }
    };
    private Emitter.Listener onJoined = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onJoined: " + objects[0]);
            try {
                String[] split = StringUtils.split((String)objects[0], '/');
                if (split[1] != null) {
                    SocketManager.post(split[1]);
                }
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
        }
    };
    private Emitter.Listener onLeaved = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onLeaved: " + objects[0]);
            try {
                String[] stringArray = StringUtils.split((String)objects[0], '/');
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
        }
    };
    private Emitter.Listener onUnauthorized = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.e("onUnauthorized: " + objects[0].toString());
            SocketManager.this.ready.set(false);
            SocketManager.this.forceDisconnect.set(true);
            SocketManager.this.socket.disconnect();
        }
    };
    private Emitter.Listener onPush = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onPush: " + objects[0].toString());
            try {
                JSONObject json = (JSONObject)objects[0];
                UserChat userChat = null;
                ProfileEntity person = null;
                String type = json.getString("type");
                if (json.has("refers")) {
                    JSONObject refers = json.getJSONObject("refers");
                    if (refers.has("bot")) {
                        person = (ProfileEntity)SocketManager.this.parseJson(refers.getString("bot"), Bot.class);
                    }
                    if (refers.has("manager")) {
                        person = (ProfileEntity)SocketManager.this.parseJson(refers.getString("manager"), Manager.class);
                    }
                    if (refers.has("userChat")) {
                        userChat = (UserChat)SocketManager.this.parseJson(refers.getString("userChat"), UserChat.class);
                    }
                }
                switch (type) {
                    case "Message": {
                        Log log;
                        Message message = (Message)SocketManager.this.parseJson(json.getString("entity"), Message.class);
                        if (message == null) break;
                        String string2 = null;
                        long createdAt = message.getCreatedAt();
                        String title = message.getTitle();
                        if (message.getMessage() != null) {
                            string2 = message.getMessage();
                        } else if (message.getFile() != null) {
                            string2 = message.getFile().isImage() ? ResUtils.getString((Context)SocketManager.this.application, "ch.notification.upload_image.description") : ResUtils.getString((Context)SocketManager.this.application, "ch.notification.upload_file.description");
                        } else if (message.getLog() != null && "resolve".equals((log = message.getLog()).getAction())) {
                            string2 = ResUtils.getString((Context)SocketManager.this.application, "ch.review.require.preview");
                        }
                        Activity topActivity = GlobalStore.get().topActivity.get();
                        if (string2 == null || userChat == null || person == null || topActivity == null || ChannelUtils.isChannelPluginActivity((Context)topActivity)) break;
                        InAppPushItem inAppPushItem = new InAppPushItem(createdAt, person, title, string2, userChat.getId());
                        InAppPushStore.get().inAppPushItem.set(inAppPushItem);
                    }
                }
            }
            catch (Exception e) {
                L.e(e.getMessage());
            }
        }
    };
    private Emitter.Listener onCreate = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("+ onCreate) " + SocketManager.this.getTag((JSONObject)objects[0]) + objects[0].toString());
            SocketManager.this.onMessage((JSONObject)objects[0], true);
        }
    };
    private Emitter.Listener onUpdate = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("~ onUpdate) " + SocketManager.this.getTag((JSONObject)objects[0]) + objects[0].toString());
            SocketManager.this.onMessage((JSONObject)objects[0], true);
        }
    };
    private Emitter.Listener onDelete = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("- onDelete) " + SocketManager.this.getTag((JSONObject)objects[0]) + objects[0].toString());
            SocketManager.this.onMessage((JSONObject)objects[0], false);
        }
    };

    public static Observable<String> observable() {
        return chatJoinedPublishSubject.onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread());
    }

    public static void post(String chatId) {
        if (chatJoinedPublishSubject != null) {
            chatJoinedPublishSubject.onNext((Object)chatId);
        }
    }

    public static void create(Application application) {
        if (socketManager == null) {
            socketManager = new SocketManager();
            SocketManager.socketManager.application = application;
            socketManager.init();
        }
    }

    private void init() {
        this.forceDisconnect = new AtomicBoolean(false);
        this.ready = new AtomicBoolean(false);
        this.error = new AtomicBoolean(false);
        this.reconnectQueue = new ArrayBlockingQueue<Integer>(1);
        try {
            IO.Options options = new IO.Options();
            options.reconnection = false;
            options.transports = new String[]{"websocket"};
            this.socket = IO.socket((String)SOCKET_END_POINT, (IO.Options)options);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.socket.on("connect", this.onConnect);
        this.socket.on("connect_error", this.onConnectError);
        this.socket.on("connect_timeout", this.onConnectTimeout);
        this.socket.on("connecting", this.onConnecting);
        this.socket.on("disconnect", this.onDisconnect);
        this.socket.on("error", this.onError);
        this.socket.on("ping", this.onPing);
        this.socket.on("pong", this.onPong);
        this.socket.on("reconnect", this.onReconnect);
        this.socket.on("reconnect_attempt", this.onReconnectAttempt);
        this.socket.on("reconnect_error", this.onReconnectError);
        this.socket.on("reconnect_failed", this.onReconnectFailed);
        this.socket.on("reconnecting", this.onReconnecting);
        this.socket.on("authenticated", this.onAuthenticated);
        this.socket.on("ready", this.onReady);
        this.socket.on("create", this.onCreate);
        this.socket.on("delete", this.onDelete);
        this.socket.on("joined", this.onJoined);
        this.socket.on("leaved", this.onLeaved);
        this.socket.on("push", this.onPush);
        this.socket.on("unauthorized", this.onUnauthorized);
        this.socket.on("update", this.onUpdate);
        this.socket.on("typing", this.onTyping);
    }

    public static void setChannelId(@Nullable String channelId) {
        if (socketManager != null) {
            SocketManager.socketManager.channelId = channelId;
        }
    }

    public static boolean isReady() {
        if (socketManager != null) {
            return SocketManager.socketManager.ready.get();
        }
        return false;
    }

    public static boolean isError() {
        if (socketManager != null) {
            return SocketManager.socketManager.error.get();
        }
        return false;
    }

    public static void connect() {
        if (socketManager != null) {
            socketManager.connectSocket();
        }
    }

    public static void reconnect() {
        if (socketManager != null && GlobalStore.get().messengerState.get().booleanValue()) {
            socketManager.enqueueReconnect();
        }
    }

    public static void joinChat(@Nullable String chatId) {
        if (socketManager != null) {
            socketManager.chatAction("join", chatId);
        }
    }

    public static void leaveChat(@Nullable String chatId) {
        if (socketManager != null) {
            socketManager.chatAction("leave", chatId);
        }
    }

    public static void typing(Typing typing) {
        try {
            if (socketManager != null) {
                socketManager.emit("typing", new JSONObject(new Gson().toJson((Object)typing)));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void disconnect() {
        if (socketManager != null) {
            socketManager.disconnect(true);
            socketManager.stopHeartbeat();
        }
    }

    public static void destroy() {
        if (socketManager != null) {
            socketManager.setReconnectConsumer(false);
            SocketManager.socketManager.socket.off();
            SocketManager.socketManager.socket.disconnect();
            SocketManager.socketManager.channelId = null;
            SocketManager.socketManager.forceDisconnect = null;
            SocketManager.socketManager.ready = null;
            SocketManager.socketManager.reconnectQueue = null;
            SocketManager.socketManager.socket = null;
            socketManager = null;
        }
    }

    private void enqueueReconnect() {
        if (!this.ready.get()) {
            try {
                this.reconnectQueue.add(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void clearReconnectQueue() {
        try {
            this.reconnectQueue.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void connectSocket() {
        if (this.socket != null && !this.socket.connected() && this.channelId != null) {
            L.d("try connect");
            this.socket.connect();
            this.setReconnectConsumer(true);
        }
    }

    private void disconnect(boolean force) {
        this.forceDisconnect.set(force);
        try {
            this.clearReconnectQueue();
            this.socket.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!force) {
            this.enqueueReconnect();
        } else {
            this.setReconnectConsumer(false);
        }
    }

    private void authentication() {
        String jwt = GlobalStore.get().jwt.get();
        if (jwt == null) {
            this.disconnect(true);
        } else {
            String info = String.format("{\"jwt\": \"%s\"}", jwt);
            try {
                JSONObject jsonObject = new JSONObject(info);
                this.emit("authentication", jsonObject);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized void setReconnectConsumer(boolean flag) {
        if (flag) {
            if (this.reconnectConsumer == null) {
                this.reconnectConsumer = new Timer();
                this.reconnectConsumer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            Integer data = (Integer)SocketManager.this.reconnectQueue.peek();
                            if (data != null) {
                                int index = Math.min(SocketManager.this.attemptCount.getAndIncrement(), SocketManager.this.attemptDelay.length - 1);
                                Thread.sleep(SocketManager.this.attemptDelay[index] * 1000);
                                SocketManager.this.reconnectQueue.remove();
                                SocketManager.this.connectSocket();
                            }
                        }
                        catch (Exception e) {
                            L.e(e.getMessage());
                        }
                    }
                }, 500L, 500L);
            }
        } else if (this.reconnectConsumer != null) {
            try {
                this.reconnectConsumer.cancel();
            }
            catch (Exception exception) {
            }
            finally {
                this.reconnectConsumer = null;
            }
        }
    }

    private void startHeartbeat() {
        this.stopHeartbeat();
        this.sendHeartbeat();
        this.heartbeat = Observable.interval((long)30000L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe((Subscriber)new Subscriber<Long>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Long aLong) {
                SocketManager.this.sendHeartbeat();
            }
        });
    }

    private void sendHeartbeat() {
        try {
            L.i("Heartbeat");
            this.socket.emit("heartbeat", new Object[]{""});
        }
        catch (Exception ex) {
            L.e("socket error");
        }
    }

    private synchronized void stopHeartbeat() {
        if (this.heartbeat != null && !this.heartbeat.isUnsubscribed()) {
            this.heartbeat.unsubscribe();
        }
    }

    private void emit(String event, Object object) {
        if (object == null || this.socket == null) {
            return;
        }
        this.socket.emit(event, new Object[]{object});
    }

    private void chatAction(String action, @Nullable String chatId) {
        if (this.socket == null) {
            return;
        }
        if (chatId == null || !this.ready.get()) {
            return;
        }
        String message = String.format("/user_chats/%s", chatId);
        this.emit(action, message);
    }

    private String getTag(JSONObject json) {
        try {
            String type = json.getString("type");
            String id2 = json.getJSONObject("entity").getString("id");
            return String.format("%s (%s): ", type, id2);
        }
        catch (Exception ex) {
            return "";
        }
    }

    private void onMessage(JSONObject json, boolean upsert) {
        try {
            String type;
            if (!json.has("type") || !json.has("entity")) {
                return;
            }
            String entity = json.getString("entity");
            switch (type = json.getString("type")) {
                case "Bot": {
                    Bot bot = this.parseJson(entity, Bot.class);
                    if (bot == null) break;
                    BotStore.get().bots.upsert(bot);
                    break;
                }
                case "Manager": {
                    Manager manager = this.parseJson(entity, Manager.class);
                    if (manager == null) {
                        return;
                    }
                    ManagerStore.get().managers.upsert(manager);
                    break;
                }
                case "Message": {
                    JSONObject refers;
                    Message message = this.parseJson(entity, Message.class);
                    if (message == null) {
                        return;
                    }
                    if (json.has("refers") && (refers = json.getJSONObject("refers")).has("bot")) {
                        Bot botRefers = this.parseJson(refers.getString("bot"), Bot.class);
                        BotStore.get().bots.upsert(botRefers);
                    }
                    UserChatStore.get().messages.upsert(message);
                    ChatStore.get().messages.add(message);
                    break;
                }
                case "UserChat": {
                    UserChat userChat = this.parseJson(entity, UserChat.class);
                    if (userChat == null) {
                        return;
                    }
                    if (json.has("refers")) {
                        JSONObject refers = json.getJSONObject("refers");
                        if (refers.has("message")) {
                            Message referMessage = this.parseJson(refers.getString("message"), Message.class);
                            UserChatStore.get().messages.upsert(referMessage);
                        }
                        if (refers.has("manager")) {
                            Manager referManager = this.parseJson(refers.getString("manager"), Manager.class);
                            ManagerStore.get().managers.upsert(referManager);
                        }
                        if (refers.has("bot")) {
                            Bot referBot = this.parseJson(refers.getString("bot"), Bot.class);
                            BotStore.get().bots.upsert(referBot);
                        }
                    }
                    UserChatStore.get().userChats.upsert(userChat);
                    break;
                }
                case "Session": {
                    Session session = this.parseJson(entity, Session.class);
                    if (session == null) {
                        return;
                    }
                    if (json.has("refers")) {
                        JSONObject refers = json.getJSONObject("refers");
                        if (refers.has("bot")) {
                            Bot referBot = this.parseJson(refers.getString("bot"), Bot.class);
                            BotStore.get().bots.upsert(referBot);
                        }
                        if (refers.has("manager")) {
                            Manager referManager = this.parseJson(refers.getString("manager"), Manager.class);
                            ManagerStore.get().managers.upsert(referManager);
                        }
                    }
                    if (upsert) {
                        UserChatStore.get().sessions.upsert(session);
                        break;
                    }
                    UserChatStore.get().sessions.remove(session);
                    break;
                }
                case "Channel": {
                    Channel channel = this.parseJson(entity, Channel.class);
                    if (channel == null) break;
                    Store2.getInstance(ChannelStore.class).channelState.set(channel);
                    break;
                }
                case "Veil": {
                    Veil veil = this.parseJson(entity, Veil.class);
                    if (veil == null) break;
                    GuestStore.get().guest.set(veil);
                    break;
                }
                case "User": {
                    User user = this.parseJson(entity, User.class);
                    if (user == null) break;
                    GuestStore.get().guest.set(user);
                }
            }
        }
        catch (Exception ex) {
            L.e(ex.getMessage());
        }
    }

    private <T> T parseJson(String entity, Class<T> target) {
        if (entity == null) {
            return null;
        }
        try {
            return (T)ParseUtils.getCustomGson().fromJson(entity, target);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static {
        chatJoinedPublishSubject = PublishSubject.create();
        SOCKET_END_POINT = "https://ws.channel.io/app";
    }
}

