/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.action.GuestAction;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.model.etc.InAppPushItem;
import com.zoyi.channel.plugin.android.model.etc.PushEvent;
import com.zoyi.channel.plugin.android.selector2.GlobalSelector;
import com.zoyi.channel.plugin.android.selector2.GuestSelector;
import com.zoyi.channel.plugin.android.selector2.SocketSelector;
import com.zoyi.channel.plugin.android.store2.TimerStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public class ChannelActionHandler {
    @Nullable
    private ChannelPluginListener listener;
    @Nullable
    private Binder socketBinder;
    @Nullable
    private Binder countHandler;
    @Nullable
    private Binder inAppPushHandler;
    @Nullable
    private Subscription workingTimer;

    public void handle() {
        this.socketBinder = SocketSelector.bindSocket((Action1<SocketStatus>)((Action1)socketStatus -> {
            if (socketStatus == SocketStatus.READY) {
                GuestAction.touch();
            }
        }));
        this.countHandler = GuestSelector.bindGuestAlertCount((Action1<Integer>)((Action1)count -> {
            if (this.listener != null && count != null) {
                this.listener.onChangeBadge((int)count);
            }
        }));
        this.inAppPushHandler = GlobalSelector.bindInAppPush((Action1<InAppPushItem>)((Action1)inAppPushItem -> {
            if (this.listener != null && inAppPushItem != null) {
                this.listener.onReceivePush(new PushEvent((InAppPushItem)inAppPushItem));
            }
        }));
        this.workingTimer = Observable.interval((long)60L, (TimeUnit)TimeUnit.SECONDS).onBackpressureBuffer().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(l -> TimerStore.get().now.set(TimeUtils.getCurrentTime()));
        TimerStore.get().now.set(TimeUtils.getCurrentTime());
    }

    public void unHandle() {
        if (this.socketBinder != null) {
            this.socketBinder.unbind();
            this.socketBinder = null;
        }
        if (this.countHandler != null) {
            this.countHandler.unbind();
            this.countHandler = null;
        }
        if (this.inAppPushHandler != null) {
            this.inAppPushHandler.unbind();
            this.inAppPushHandler = null;
        }
        if (this.workingTimer != null) {
            if (!this.workingTimer.isUnsubscribed()) {
                this.workingTimer.unsubscribe();
            }
            this.workingTimer = null;
        }
    }

    @Nullable
    public ChannelPluginListener getListener() {
        return this.listener;
    }

    public void setListener(@Nullable ChannelPluginListener listener) {
        this.listener = listener;
    }

    public void clearListener() {
        this.listener = null;
    }
}

