package com.zoyi.channel.plugin.android.store2;

import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store2.base.Store2;
import com.zoyi.channel.plugin.android.store2.state.*;

public class UserChatStore extends Store2 {

  public EntityMapState<UserChat> userChats = new EntityMapState<>();

  public UpdatableMapState<String, Session> sessions = new UpdatableMapState<>(Session::getChatId);

  public MapState<String, Message> messages = new MapState<>(Message::getChatId);

  public EnumState<FetchState> userChatsFetchState = new EnumState<>(FetchState.LOADING);

  @Override
  protected void reset() {
    userChats.reset();
    sessions.reset();
    messages.reset();
    userChatsFetchState.reset();
  }

  public static UserChatStore get() {
    return Store2.getInstance(UserChatStore.class);
  }
}
