package com.zoyi.channel.plugin.android.store2;

import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.LauncherConfig;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.store2.base.Store2;
import com.zoyi.channel.plugin.android.store2.state.BooleanState;
import com.zoyi.channel.plugin.android.store2.state.EnumState;
import com.zoyi.channel.plugin.android.store2.state.State;

public class SettingsStore extends Store2 {

  public BooleanState showLauncher = new BooleanState(false);

  public EnumState<CHLocale> locale = new EnumState<>(CHLocale.DEVICE);

  public BooleanState showTranslation = new BooleanState(true);

  public BooleanState showClosedChat = new BooleanState(true);

  public BooleanState raiseSoundVibrate = new BooleanState(true);

  public BooleanState enabledTrackDefaultEvent = new BooleanState(Const.DEFAULT_SETTINGS_ENABLED_TRACK_DEFAULT_EVENT);

  public BooleanState hideDefaultInAppPush = new BooleanState(Const.DEFAULT_SETTINGS_HIDE_DEFAULT_IN_APP_PUSH);

  public State<LauncherConfig> launcherConfig = new State<>();

  @Override
  protected void reset() {
    locale.reset();
    showTranslation.reset();
    showClosedChat.reset();
    raiseSoundVibrate.reset();
    enabledTrackDefaultEvent.reset();
    hideDefaultInAppPush.reset();
    launcherConfig.reset();
  }

  public static SettingsStore get() {
    return Store2.getInstance(SettingsStore.class);
  }
}
