/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.annimon.stream;

import com.zoyi.com.annimon.stream.Objects;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.annimon.stream.function.Consumer;
import com.zoyi.com.annimon.stream.function.Function;
import com.zoyi.com.annimon.stream.function.Supplier;
import com.zoyi.com.annimon.stream.function.ThrowableFunction;
import com.zoyi.com.annimon.stream.function.ThrowableSupplier;

public class Exceptional<T> {
    private final T value;
    private final Throwable throwable;

    public static <T> Exceptional<T> of(ThrowableSupplier<T, Throwable> supplier) {
        try {
            return new Exceptional<T>(supplier.get(), null);
        }
        catch (Throwable throwable) {
            return Exceptional.of(throwable);
        }
    }

    public static <T> Exceptional<T> of(Throwable throwable) {
        return new Exceptional<Object>(null, throwable);
    }

    private Exceptional(T value, Throwable throwable) {
        this.value = value;
        this.throwable = throwable;
    }

    public T get() {
        return this.value;
    }

    public boolean isPresent() {
        return this.throwable == null;
    }

    public T getOrElse(T other) {
        return this.throwable == null ? this.value : other;
    }

    public T getOrElse(Supplier<? extends T> other) {
        return this.throwable == null ? this.value : other.get();
    }

    public Optional<T> getOptional() {
        return Optional.ofNullable(this.value);
    }

    public Throwable getException() {
        return this.throwable;
    }

    public T getOrThrow() throws Throwable {
        if (this.throwable != null) {
            throw this.throwable;
        }
        return this.value;
    }

    public T getOrThrowRuntimeException() throws RuntimeException {
        if (this.throwable != null) {
            throw new RuntimeException(this.throwable);
        }
        return this.value;
    }

    public <E extends Throwable> T getOrThrow(E exception) throws E {
        if (this.throwable != null) {
            exception.initCause(this.throwable);
            throw exception;
        }
        return this.value;
    }

    public Exceptional<T> or(Supplier<Exceptional<T>> supplier) {
        if (this.throwable == null) {
            return this;
        }
        Objects.requireNonNull(supplier);
        return Objects.requireNonNull(supplier.get());
    }

    public <R> R custom(Function<Exceptional<T>, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    public <U> Exceptional<U> map(ThrowableFunction<? super T, ? extends U, Throwable> mapper) {
        if (this.throwable != null) {
            return Exceptional.of(this.throwable);
        }
        Objects.requireNonNull(mapper);
        try {
            return new Exceptional<U>(mapper.apply(this.value), null);
        }
        catch (Throwable t) {
            return Exceptional.of(t);
        }
    }

    public Exceptional<T> ifPresent(Consumer<? super T> consumer) {
        if (this.throwable == null) {
            consumer.accept(this.value);
        }
        return this;
    }

    public Exceptional<T> ifException(Consumer<Throwable> consumer) {
        if (this.throwable != null) {
            consumer.accept(this.throwable);
        }
        return this;
    }

    public <E extends Throwable> Exceptional<T> ifExceptionIs(Class<E> throwableClass, Consumer<? super E> consumer) {
        if (this.throwable != null && throwableClass.isAssignableFrom(this.throwable.getClass())) {
            consumer.accept(this.throwable);
        }
        return this;
    }

    public Exceptional<T> recover(ThrowableFunction<Throwable, ? extends T, Throwable> function) {
        if (this.throwable == null) {
            return this;
        }
        Objects.requireNonNull(function);
        try {
            return new Exceptional<T>(function.apply(this.throwable), null);
        }
        catch (Throwable throwable) {
            return Exceptional.of(throwable);
        }
    }

    public Exceptional<T> recoverWith(Function<Throwable, ? extends Exceptional<T>> function) {
        if (this.throwable == null) {
            return this;
        }
        Objects.requireNonNull(function);
        return Objects.requireNonNull(function.apply(this.throwable));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Exceptional)) {
            return false;
        }
        Exceptional other = (Exceptional)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.throwable, other.throwable);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.throwable);
    }

    public String toString() {
        return this.throwable == null ? String.format("Exceptional value %s", this.value) : String.format("Exceptional throwable %s", this.throwable);
    }
}

