/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.functions.Func2;
import com.zoyi.rx.internal.producers.ProducerArbiter;
import com.zoyi.rx.schedulers.Schedulers;
import com.zoyi.rx.subscriptions.SerialSubscription;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorRetryWithPredicate<T>
implements Observable.Operator<T, Observable<T>> {
    final Func2<Integer, Throwable, Boolean> predicate;

    public OperatorRetryWithPredicate(Func2<Integer, Throwable, Boolean> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Subscriber<? super Observable<T>> call(Subscriber<? super T> child) {
        Scheduler.Worker inner = Schedulers.trampoline().createWorker();
        child.add(inner);
        SerialSubscription serialSubscription = new SerialSubscription();
        child.add(serialSubscription);
        ProducerArbiter pa = new ProducerArbiter();
        child.setProducer(pa);
        return new SourceSubscriber<T>(child, this.predicate, inner, serialSubscription, pa);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SourceSubscriber<T>
    extends Subscriber<Observable<T>> {
        final Subscriber<? super T> child;
        final Func2<Integer, Throwable, Boolean> predicate;
        final Scheduler.Worker inner;
        final SerialSubscription serialSubscription;
        final ProducerArbiter pa;
        final AtomicInteger attempts = new AtomicInteger();

        public SourceSubscriber(Subscriber<? super T> child, Func2<Integer, Throwable, Boolean> predicate, Scheduler.Worker inner, SerialSubscription serialSubscription, ProducerArbiter pa) {
            this.child = child;
            this.predicate = predicate;
            this.inner = inner;
            this.serialSubscription = serialSubscription;
            this.pa = pa;
        }

        @Override
        public void onCompleted() {
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onNext(final Observable<T> o) {
            this.inner.schedule(new Action0(){

                public void call() {
                    final 1 _self = this;
                    SourceSubscriber.this.attempts.incrementAndGet();
                    Subscriber subscriber = new Subscriber<T>(){
                        boolean done;

                        @Override
                        public void onCompleted() {
                            if (!this.done) {
                                this.done = true;
                                SourceSubscriber.this.child.onCompleted();
                            }
                        }

                        @Override
                        public void onError(Throwable e) {
                            if (!this.done) {
                                this.done = true;
                                if (SourceSubscriber.this.predicate.call(SourceSubscriber.this.attempts.get(), e).booleanValue() && !SourceSubscriber.this.inner.isUnsubscribed()) {
                                    SourceSubscriber.this.inner.schedule(_self);
                                } else {
                                    SourceSubscriber.this.child.onError(e);
                                }
                            }
                        }

                        @Override
                        public void onNext(T v) {
                            if (!this.done) {
                                SourceSubscriber.this.child.onNext(v);
                                SourceSubscriber.this.pa.produced(1L);
                            }
                        }

                        @Override
                        public void setProducer(Producer p) {
                            SourceSubscriber.this.pa.setProducer(p);
                        }
                    };
                    SourceSubscriber.this.serialSubscription.set(subscriber);
                    o.unsafeSubscribe(subscriber);
                }
            });
        }
    }
}

