package com.zoyi.channel.plugin.android.selector2;

import android.content.Context;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.rest.PushBot;
import com.zoyi.channel.plugin.android.store2.PushBotStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.store2.binder.Binder1;
import com.zoyi.channel.plugin.android.store2.state.EntityMapState;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.rx.functions.Action1;

public class PushBotSelector {

  public static Binder bindPopupPushBot(Context context, Action1<PushBotItem> action1) {
    EntityMapState<PushBotItem> pushBotsState = PushBotStore.get().pushBots;

    return new Binder1<>(pushBotsState).bind((pushBotItems) -> {
      for (PushBotItem pushBotItem : pushBotItems.values()) {
        if (pushBotItem.shouldShowToPopup() && ChannelUtils.isSameActivity(context, pushBotItem.getTargetActivity())) {
          action1.call(pushBotItem);
          return;
        }
      }
      action1.call(null);
    });
  }

  public static boolean canTryReach(@Nullable PushBot pushBot) {
    return pushBot != null && pushBot.getId() != null && PushBotStore.get().pushBots.get(pushBot.getId()) == null;
  }
}
