package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.store2.SettingsStore;

/**
 * Created by mika on 2017. 1. 26..
 */
public class I18n {

  private String text;
  private String en;
  private String ko;
  private String ja;

  public String getText() {
    return text;
  }

  private String getEn() {
    if (en != null) {
      return en;
    } else {
      return text;
    }
  }

  private String getKo() {
    if (ko != null) {
      return ko;
    } else {
      return text;
    }
  }

  private String getJa() {
    if (ja != null) {
      return ja;
    } else {
      return text;
    }
  }

  @Nullable
  private String getLocaleText(String lang) {
    if (lang != null) {
      switch (lang) {
        case Const.KOREAN:
          return getKo();
        case Const.JAPANESE:
          return getJa();
        case Const.ENGLISH:
          return getEn();
      }
    }
    return null;
  }

  @Nullable
  public String get(String lang) {
    String localeString = getLocaleText(lang);

    if (localeString != null) {
      return localeString;
    }
    return getText();
  }

  @Nullable
  public String get() {
    return get(SettingsStore.get().locale.get().toString());
  }
}
