/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.AssemblyStackTraceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OnSubscribeOnAssembly<T>
implements Observable.OnSubscribe<T> {
    final Observable.OnSubscribe<T> source;
    final String stacktrace;
    public static volatile boolean fullStackTrace;

    public OnSubscribeOnAssembly(Observable.OnSubscribe<T> source) {
        this.source = source;
        this.stacktrace = OnSubscribeOnAssembly.createStacktrace();
    }

    static String createStacktrace() {
        StackTraceElement[] stacktraceElements = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder("Assembly trace:");
        for (StackTraceElement e : stacktraceElements) {
            String row = e.toString();
            if (!fullStackTrace && (e.getLineNumber() <= 1 || row.contains("RxJavaHooks.") || row.contains("OnSubscribeOnAssembly") || row.contains(".junit.runner") || row.contains(".junit4.runner") || row.contains(".junit.internal") || row.contains("sun.reflect") || row.contains("java.lang.Thread.") || row.contains("ThreadPoolExecutor") || row.contains("org.apache.catalina.") || row.contains("org.apache.tomcat."))) continue;
            sb.append("\n at ").append(row);
        }
        return sb.append("\nOriginal exception:").toString();
    }

    @Override
    public void call(Subscriber<? super T> t) {
        this.source.call(new OnAssemblySubscriber<T>(t, this.stacktrace));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class OnAssemblySubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        final String stacktrace;

        public OnAssemblySubscriber(Subscriber<? super T> actual, String stacktrace) {
            super(actual);
            this.actual = actual;
            this.stacktrace = stacktrace;
        }

        @Override
        public void onCompleted() {
            this.actual.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            new AssemblyStackTraceException(this.stacktrace).attachTo(e);
            this.actual.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }
    }
}

