/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.textview;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.selector2.SettingsSelector;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.textview.OnTextContentChangeListener;
import com.zoyi.rx.functions.Action1;

public class CHTextView
extends AppCompatTextView {
    private Context context;
    @Nullable
    private String textKey;
    private boolean isHtml;
    @Nullable
    private Binder binder;
    @Nullable
    private OnTextContentChangeListener onTextContentChangeListener;
    @Nullable
    private Object data;

    public CHTextView(Context context) {
        super(context);
        this.init(context, null);
    }

    public CHTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CHTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    private void init(Context context, @Nullable AttributeSet attrs) {
        this.context = context;
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ChannelTextBasedView);
            try {
                this.textKey = typedArray.getString(R.styleable.ChannelTextBasedView_ch_tv_textKey);
                this.isHtml = typedArray.getBoolean(R.styleable.ChannelTextBasedView_ch_tv_isHtml, false);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.binder = SettingsSelector.bindLocale((Action1<CHLocale>)((Action1)locale -> this.setTextKey((CHLocale)((Object)locale), this.textKey, this.data)));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.binder != null) {
            this.binder.unbind();
            this.binder = null;
        }
    }

    public void setOnTextContentChangeListener(@Nullable OnTextContentChangeListener onTextContentChangeListener) {
        this.onTextContentChangeListener = onTextContentChangeListener;
    }

    public void setData(@Nullable Object data) {
        this.data = data;
        this.setTextKey((CHLocale)((Object)SettingsStore.get().locale.get()), this.textKey, data);
    }

    public void setTextKey(@Nullable String textKey) {
        this.textKey = textKey;
        this.setTextKey((CHLocale)((Object)SettingsStore.get().locale.get()), textKey, this.data);
    }

    private void setTextKey(CHLocale locale, @Nullable String textKey, @Nullable Object data) {
        if (textKey != null) {
            String content = ResUtils.getString(this.context, locale, textKey);
            if (this.onTextContentChangeListener != null) {
                this.setContent(this.onTextContentChangeListener.onTextContentChange(content, data));
            } else {
                this.setContent(content);
            }
        }
    }

    private void setContent(@Nullable String content) {
        if (this.isHtml && content != null) {
            this.setText((CharSequence)Utils.getHtmlFormattedText(content));
        } else {
            this.setText(content);
        }
    }
}

