package com.zoyi.channel.plugin.android.store;

import android.support.annotation.NonNull;

import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.global.Const;

/**
 * Created by mika on 2018. 7. 5..
 */

public class ChannelIOSettingsStore extends Store implements DestroyableStore {

  private ChannelPluginSettings settings;

  public ChannelPluginSettings getSettings() {
    return settings;
  }

  public void setPluginSettings(ChannelPluginSettings settings) {
    this.settings = settings;
  }

  public String[] getBlockFilters() {
    return (Store.getInstance(UiStateStore.class).shouldShowClosedChat()
        ? Const.USER_CHAT_STATE_REMOVED
        : Const.USER_CHAT_STATE_CLOSED_REMOVED)
        .split("&");
  }

  @NonNull
  @Override
  protected StoreType getStoreType() {
    return StoreType.PLUGIN_SETTINGS;
  }

  @Override
  public void clearData() {
    settings = null;
  }
}
