package com.zoyi.channel.plugin.android.model.wrapper;

import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.store.*;

import java.util.List;

/**
 * Created by mika on 2016. 12. 6..
 */
public class UserChatsWrapper extends BaseRepo {
  private Long next;
  private List<UserChat> userChats;
  private List<Session> sessions;
  private List<Message> messages;
  private List<Manager> managers;
  private List<Bot> bots;

  public Long getNext() {
    return next;
  }

  public List<UserChat> getUserChats() {
    return userChats;
  }

  public List<Session> getSessions() {
    return sessions;
  }

  public List<Message> getMessages() {
    return messages;
  }

  public List<Manager> getManagers() {
    return managers;
  }

  public List<Bot> getBots() {
    return bots;
  }

  @Override
  public void set() {
    Store.getInstance(UserChatStore.class).set(userChats);
    Store.getInstance(SessionStore.class).set(sessions);
    Store.getInstance(MessageStore.class).add(messages);
    Store.getInstance(ManagerStore.class).add(managers);
    Store.getInstance(BotStore.class).add(bots);
  }

  @Override
  public void update() {
    Store.getInstance(UserChatStore.class).add(userChats);
    Store.getInstance(SessionStore.class).add(sessions);
    Store.getInstance(MessageStore.class).add(messages);
    Store.getInstance(ManagerStore.class).add(managers);
    Store.getInstance(BotStore.class).add(bots);
  }
}
