package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatActivity2;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.L;

public class ActivityLifecycleManager implements Application.ActivityLifecycleCallbacks {

  @Nullable
  private Activity topActivity;
  private int running = 0;

  @Override
  public void onActivityCreated(Activity activity, Bundle savedInstanceState) { }

  @Override
  public void onActivityStarted(Activity activity) {
    L.d("Started: " + activity.getClass().getSimpleName() + " " + running + " -> " + (running + 1));

    if (!(activity instanceof BaseActivity)) {
      FrameLayout root = activity.findViewById(R.id.channel_io_view);
      if (root == null && !activity.getClass().isAnnotationPresent(SkipAttachChannelView.class)) {
        root = new FrameLayout(activity);
        root.setClipChildren(false);
        root.setClipToPadding(false);
        root.setFitsSystemWindows(true);
        root.setId(R.id.channel_io_view);
        root.addView(new ChannelView(activity));

        activity.addContentView(root, new FrameLayout.LayoutParams(
            FrameLayout.LayoutParams.MATCH_PARENT,
            FrameLayout.LayoutParams.MATCH_PARENT));
      }
    }

    topActivity = activity;

    if (++running == 1) {
      RxBus.post(new CommandBus(Command.APP_STARTED));
      SocketManager.connect();
    }
  }

  @Override
  public void onActivityResumed(Activity activity) {
  }

  @Override
  public void onActivityPaused(Activity activity) {
  }

  @Override
  public void onActivityStopped(Activity activity) {
    L.d("Stopped: " + activity.getClass().getSimpleName() + " " + running + " -> " + (running - 1));

    if (topActivity == activity) {
      topActivity = null;
    }
    if (--running == 0) {
      SocketManager.disconnect();
      RxBus.post(new CommandBus(Command.APP_STOPPED));
    }
  }

  @Override
  public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
  }

  @Override
  public void onActivityDestroyed(Activity activity) { }

  @Nullable
  Activity getTopActivity() {
    return topActivity;
  }

  public void finishExistChatActivity() {
    if (topActivity instanceof ChatActivity2) {
      ((BaseActivity) topActivity).finish();
    }
  }

  public void finish(boolean animated) {
    if (topActivity != null && topActivity instanceof BaseActivity) {
      topActivity.setResult(Const.RESULT_ACTIVITY_FINISH);
      ((BaseActivity) topActivity).finish(animated);
    }
  }
}
