/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelIOManager;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.global.ChannelFileProvider;
import com.zoyi.channel.plugin.android.util.FileUtils;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.message_format.type.LinkType;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Executor {
    private static String photoPath = null;

    public static boolean takePhoto(Activity activity) {
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        File photoFile = Executor.getPhotoFile();
        if (photoFile == null) {
            return false;
        }
        takePictureIntent.putExtra("output", (Parcelable)ChannelFileProvider.getUriForFile((Context)activity, Executor.getPhotoFile()));
        if (takePictureIntent.resolveActivity(activity.getPackageManager()) != null) {
            activity.startActivityForResult(takePictureIntent, 3000);
            return true;
        }
        return false;
    }

    public static void startFileMediaScan(Activity activity, String filePath) {
        Executor.startFileMediaScan(activity, new File(filePath));
    }

    public static void startFileMediaScan(Activity activity, File file) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        mediaScanIntent.setData(Uri.fromFile((File)file));
        activity.sendBroadcast(mediaScanIntent);
    }

    public static void executeLinkAction(@Nullable Context context, @Nullable String link, LinkType linkType) {
        if (context != null && link != null) {
            boolean handleLink = false;
            ChannelPluginListener channelPluginListener = ChannelIOManager.getChannelPluginListener();
            if (channelPluginListener != null) {
                handleLink = channelPluginListener.onClickChatLink(link);
            }
            if (!handleLink) {
                switch (linkType) {
                    case URL: {
                        IntentUtils.setUrl(context, link).startActivity();
                        break;
                    }
                    case PHONE: {
                        IntentUtils.setPhone(context, link).startActivity();
                        break;
                    }
                    case EMAIL: {
                        IntentUtils.setEmail(context, link).startActivity();
                    }
                }
            }
        }
    }

    public static void executeRedirectUrlAction(@Nullable Context context, @Nullable String url) {
        if (context != null && url != null) {
            boolean handleRedirectUrl = false;
            ChannelPluginListener channelPluginListener = ChannelIOManager.getChannelPluginListener();
            if (channelPluginListener != null) {
                handleRedirectUrl = channelPluginListener.onClickRedirectUrl(url);
            }
            if (!handleRedirectUrl) {
                IntentUtils.setUrl(context, url).startActivity();
            }
        }
    }

    public static String getPhotoPath() {
        return photoPath;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private static File getPhotoFile() {
        File file = null;
        try {
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            file = File.createTempFile(timeStamp, ".jpg", FileUtils.getPhotoDirectory());
            photoPath = file.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static void call(Context context, String phoneNumber) {
        if (TextUtils.isEmpty((CharSequence)phoneNumber)) {
            return;
        }
        Intent intent = new Intent("android.intent.action.DIAL");
        intent.setData(Uri.parse((String)("tel:" + phoneNumber)));
        if (intent.resolveActivity(context.getPackageManager()) != null) {
            context.startActivity(intent);
        }
    }
}

