/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.selector.BaseSelector;
import com.zoyi.channel.plugin.android.store.PushBotItemStore;
import com.zoyi.channel.plugin.android.store.Store;
import java.util.ArrayList;
import java.util.List;

public class PushBotSelector
extends BaseSelector {
    @Nullable
    public static PushBotItem get(@Nullable String pushBotItemId) {
        return (PushBotItem)Store.getInstance(PushBotItemStore.class).get(pushBotItemId);
    }

    private static List<PushBotItem> getAllPushBotItems() {
        return Store.getInstance(PushBotItemStore.class).get();
    }

    public static List<PushBotItem> getVisiblePushBotItems() {
        ArrayList<PushBotItem> visiblePushBotItems = new ArrayList<PushBotItem>();
        for (PushBotItem pushBotItem : PushBotSelector.getAllPushBotItems()) {
            if (!pushBotItem.shouldShowToList()) continue;
            visiblePushBotItems.add(pushBotItem);
        }
        return visiblePushBotItems;
    }

    public static int getTotalVisiblePushBotCount() {
        int count = 0;
        for (PushBotItem pushBotItem : PushBotSelector.getVisiblePushBotItems()) {
            count += pushBotItem.getAlertCount();
        }
        return count;
    }

    public static boolean hasVisiblePushBot() {
        return PushBotSelector.getTotalVisiblePushBotCount() > 0;
    }

    public static boolean canTryReach(@Nullable String pushBotId) {
        return pushBotId != null && Store.getInstance(PushBotItemStore.class).get(pushBotId) == null;
    }
}

