package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.ColorSelector;

public class ChannelLayout extends ProfileLayout {

  public ChannelLayout(Context context) {
    super(context);
    init(context, null);
  }

  public ChannelLayout(Context context, AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public ChannelLayout(Context context, AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @TargetApi(Build.VERSION_CODES.LOLLIPOP)
  public ChannelLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
    super(context, attrs, defStyleAttr, defStyleRes);
    init(context, attrs);
  }

  protected void init(Context context, @Nullable AttributeSet attrs) {
    super.init(context, LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_channel, this), attrs);
  }

  public void set(Channel channel, Plugin plugin) {
    if (channel != null && plugin != null && image != null && back != null && text != null) {
      image.setVisibility(View.GONE);

      back.setBackgroundColor(ColorSelector.getBackgroundColor());
      text.setTextColor(ColorSelector.getTextColor());
      text.setVisibility(View.VISIBLE);
    }
  }
}
