package com.zoyi.channel.plugin.android.util.message_format.span;

import android.support.annotation.NonNull;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.view.View;

import com.zoyi.channel.plugin.android.ChannelIOManager;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.message_format.type.LinkType;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class LinkSpan extends ClickableSpan {

  private String linkText;
  private int linkColor;
  private LinkType linkType;

  public LinkSpan(String linkText, LinkType linkType, int linkColor) {
    this.linkText = linkText;
    this.linkType = linkType;
    this.linkColor = linkColor;

  }

  @Override
  public void onClick(View view) {
    Executor.executeLinkAction(view.getContext(), linkText, linkType);
  }

  @Override
  public void updateDrawState(@NonNull TextPaint textPaint) {
    try {
      textPaint.setColor(linkColor);
      textPaint.setUnderlineText(false);
    } catch (Exception ignored) {
    }
  }
}
