package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Log;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.GuestSelector;
import com.zoyi.channel.plugin.android.selector.TokenSelector;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.Request;
import com.zoyi.okhttp3.Response;

import java.io.IOException;

/**
 * Created by mika on 2016. 3. 14..
 */
public class RetrofitInterceptor implements Interceptor {
  @Override
  public Response intercept(Chain chain) throws IOException {
    Request request = chain.request();

    Request.Builder builder = request.newBuilder();
    builder = builder.header(Const.ACCEPT_LANGUAGE, PrefSupervisor.getPluginLanguage(ChannelIO.getAppContext()));

    String jwt = TokenSelector.getJwt();

    if (jwt != null) {
      builder.header(Const.X_GUEST_JWT, jwt);
    }

    return chain.proceed(builder.build());
  }
}
