package com.zoyi.channel.plugin.android.model.wrapper;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.SupportBotEntry;
import com.zoyi.channel.plugin.android.store.*;

public class ChatPreloadRepo extends BaseRepo {

  @Nullable
  private ManagersWrapper managersWrapper;
  @Nullable
  private PluginWrapper pluginWrapper;
  @Nullable
  private SupportBotEntry supportBotEntry;

  public ChatPreloadRepo(
      @Nullable ManagersWrapper managersWrapper,
      @Nullable PluginWrapper pluginWrapper,
      @Nullable SupportBotEntry supportBotEntry
  ) {
    this.managersWrapper = managersWrapper;
    this.pluginWrapper = pluginWrapper;
    this.supportBotEntry = supportBotEntry;
  }

  @Override
  public void update() {
    if (managersWrapper != null) {
      managersWrapper.update();
      managersWrapper.setFollowingManagers();
    }

    if (pluginWrapper != null) {
      Store.getInstance(PluginStore.class).update(pluginWrapper.getPlugin());
      Store.getInstance(ChannelStore.class).update(pluginWrapper.getChannel());
      Store.getInstance(UserStore.class).update(pluginWrapper.getUser());
      Store.getInstance(VeilStore.class).update(pluginWrapper.getVeil());
      Store.getInstance(BotStore.class).add(pluginWrapper.getBot());
      Store.getInstance(BotStore.class).setDefaultBot(pluginWrapper.getBot());
    }

    if (supportBotEntry != null && supportBotEntry.getId() != null) {
      Store.getInstance(SupportBotStore.class).set(supportBotEntry);
    }
  }
}
