package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mika on 2017. 1. 31..
 */
public class WorkingTime {
  private TimeRange sun, mon, tue, wed, thu, fri, sat;

  public String getMessage(Context context) {
    List<String> list = new ArrayList<>();

    addTimeRange(context, list, "sun", sun);
    addTimeRange(context, list, "mon", mon);
    addTimeRange(context, list, "tue", tue);
    addTimeRange(context, list, "wed", wed);
    addTimeRange(context, list, "thu", thu);
    addTimeRange(context, list, "fri", fri);
    addTimeRange(context, list, "sat", sat);

    return StringUtils.join(list, "\n\n");
  }

  private void addTimeRange(Context context, List<String> list, String key, TimeRange timeRange) {
    if (timeRange == null || timeRange.getFrom() == null || timeRange.getTo() == null) {
      return;
    }
    String title = ResUtils.getString(context, "ch.out_of_work." + key);
    String content = TimeUtils.getTimeRangeString(timeRange);

    list.add(String.format("%s: %s", title, content));
  }
}
