package com.zoyi.channel.plugin.android.activity.userchat_list.contract;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.userchat_list.model.ChatListItem;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.ChatContentType;
import com.zoyi.channel.plugin.android.base.BasePresenter;
import com.zoyi.channel.plugin.android.base.BaseView;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.model.entity.Entity;

public interface UserChatListContract {

  interface View extends BaseView<Presenter> {

    void userChatsFetched(boolean init);
    void setErrorView(boolean visible);
    void completeRemoveChat();
    void successFetchPreloadData(ChatContentType chatContentType, @Nullable String chatContentsId, Transition transition);
  }

  interface Presenter extends BasePresenter<View> {

    void fetchPreloadData(ChatContentType chatContentType, @Nullable String chatContentsId, Transition transition);
    void setAdapterView(UserChatAdapterContract.View adapterView);
    void setAdapterModel(UserChatAdapterContract.Model adapterModel);
    void refresh();
    void receiveCommand(Command command, @Nullable Object object);
    void receiveData(Entity entity, boolean upsert);
    void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity);
    void removeUserChat(String chatId);
    void removePushBotChat(String pushBotId);
    void redrawList();

    @Nullable ChatListItem getUserChatItem(@NonNull String id);
  }
}
