package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.content.Context;

import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoDataSource;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoRepository;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.rx.Subscriber;

import java.util.ArrayList;

public class PhotoPickerPresenter implements PhotoPickerContract.Presenter, OnPhotoClickListener {

  private Context context;

  private PhotoPickerContract.View photoPickerView;
  private PhotoPickerAdapterContract.View adapterView;
  private PhotoPickerAdapterContract.Model adapterModel;

  private PhotoRepository photoRepository;

  public PhotoPickerPresenter(Context context) {
    this.context = context;
    photoRepository = new PhotoRepository(new PhotoDataSource());
  }

  @Initializer
  @Override
  public void setView(PhotoPickerContract.View view) {
    this.photoPickerView = view;
  }

  @Initializer
  @Override
  public void setAdapterView(PhotoPickerAdapterContract.View adapterView) {
    this.adapterView = adapterView;
    this.adapterView.setOnPhotoClickListener(this);
  }

  @Initializer
  @Override
  public void setAdapterModel(PhotoPickerAdapterContract.Model adapterModel) {
    this.adapterModel = adapterModel;
  }

  @Override
  public void fetchPhotoItems() {
    photoRepository.getPhotoItems(context, new Subscriber<ArrayList<PhotoItem>>() {
      @Override
      public void onCompleted() {}

      @Override
      public void onError(Throwable throwable) {
        photoPickerView.loadPhotoItems(new ArrayList<PhotoItem>());
      }

      @Override
      public void onNext(ArrayList<PhotoItem> photoItems) {
        photoPickerView.loadPhotoItems(photoItems);

        adapterModel.setPhotoItems(photoItems);
        adapterModel.refreshSelectedItems();

        adapterView.notifyDataChanged();
      }
    });
  }

  @Override
  public void collectSelectedPhotoItem() {
    photoPickerView.sendPhotoPaths(adapterModel.getPhotoPaths());
  }

  @Override
  public int onPhotoClick(int position, boolean checked) {
    int selectedCount = adapterModel.selectPhotoItem(position, checked);

    photoPickerView.setMenuState(adapterModel.getSelectedItemCount());

    return selectedCount;
  }
}
