/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_album;

import android.animation.Animator;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageButton;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumPagerAdapter;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.model.entity.FileMeta;
import com.zoyi.channel.plugin.android.model.etc.LocalImageFile;
import com.zoyi.channel.plugin.android.selector.ImageFileSelector;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher;
import com.zoyi.channel.plugin.android.view.layout.PhotoViewPager;
import java.util.ArrayList;

public class PhotoAlbumActivity
extends BaseActivity
implements View.OnClickListener,
PhotoViewAttacher.OnPhotoTapListener {
    private static final int ANIMATION_DURATION = 200;
    private View layoutOverlay;
    private ImageButton downloadButton;
    private ImageButton copyLinkButton;
    private ImageButton closeButton;
    private boolean menuVisible = true;
    private PhotoViewPager viewPager;
    private PhotoAlbumPagerAdapter adapter;
    private Animator.AnimatorListener animatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animator) {
            PhotoAlbumActivity.this.menuVisible = !PhotoAlbumActivity.this.menuVisible;
            if (PhotoAlbumActivity.this.menuVisible) {
                PhotoAlbumActivity.this.layoutOverlay.setVisibility(0);
            }
        }

        public void onAnimationEnd(Animator animator) {
            PhotoAlbumActivity.this.layoutOverlay.setVisibility(PhotoAlbumActivity.this.menuVisible ? 0 : 8);
        }

        public void onAnimationCancel(Animator animator) {
        }

        public void onAnimationRepeat(Animator animator) {
        }
    };

    @Override
    @Initializer
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        int selectedImageIndex;
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_photo_album, -16777216, -1);
        boolean localImageMode = this.getIntent().getBooleanExtra("localFileViewMode", false);
        String localImageUrl = this.getIntent().getStringExtra("localFileUrl");
        String fileId = this.getIntent().getStringExtra("fileId");
        this.layoutOverlay = this.findViewById(R.id.layout_image);
        this.viewPager = (PhotoViewPager)this.findViewById(R.id.photo_view_pager);
        this.copyLinkButton = (ImageButton)this.findViewById(R.id.button_link);
        this.downloadButton = (ImageButton)this.findViewById(R.id.button_download);
        this.closeButton = (ImageButton)this.findViewById(R.id.button_close_image);
        this.downloadButton.setOnClickListener((View.OnClickListener)this);
        this.copyLinkButton.setOnClickListener((View.OnClickListener)this);
        this.closeButton.setOnClickListener((View.OnClickListener)this);
        Views.setVisibility((View)this.downloadButton, !localImageMode);
        Views.setVisibility((View)this.copyLinkButton, !localImageMode);
        ArrayList<FileMeta> imageFiles = new ArrayList<FileMeta>();
        if (localImageMode && localImageUrl != null) {
            imageFiles.add(LocalImageFile.create(localImageUrl));
            selectedImageIndex = 0;
        } else {
            imageFiles.addAll(ImageFileSelector.getImageFiles());
            selectedImageIndex = imageFiles.indexOf(ImageFileSelector.getImageFile(fileId));
        }
        this.adapter = new PhotoAlbumPagerAdapter((Context)this, imageFiles, this);
        this.viewPager.setAdapter(this.adapter);
        if (!ListUtils.hasItems(imageFiles) || selectedImageIndex < 0) {
            this.finish();
            return;
        }
        this.viewPager.setCurrentItem(selectedImageIndex);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.button_close_image) {
            this.finish();
        }
        if (id2 == R.id.button_link) {
            this.copyLink();
        }
        if (id2 == R.id.button_download) {
            this.download();
        }
    }

    private void copyLink() {
        FileMeta fileMeta = this.adapter.getItem(this.viewPager.getCurrentItem());
        if (fileMeta != null) {
            try {
                ClipboardManager clipboard = (ClipboardManager)this.getSystemService("clipboard");
                ClipData clip = ClipData.newPlainText((CharSequence)"text", (CharSequence)fileMeta.getUrl());
                clipboard.setPrimaryClip(clip);
                UIUtils.showToast((Context)this, ResUtils.getString((Context)this, "ch.photo.url_copied_to_clipboard"));
            }
            catch (Exception ex) {
                UIUtils.showToast((Context)this, ResUtils.getString((Context)this, "ch.photo.read_file_info_failed"));
            }
        }
    }

    private void download() {
        FileMeta fileMeta = this.adapter.getItem(this.viewPager.getCurrentItem());
        if (fileMeta != null) {
            IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", fileMeta.getUrl()).putExtra("filename", fileMeta.getName()).putExtra("image", true).setTransition(Transition.NONE).startActivity();
        }
    }

    @Override
    public void onPhotoTap(View view, float x, float y) {
        this.animateOverlay();
    }

    @Override
    public void onOutsidePhotoTap() {
        this.animateOverlay();
    }

    private void animateOverlay() {
        this.layoutOverlay.animate().alpha(this.menuVisible ? 0.0f : 1.0f).setDuration(200L).setListener(this.animatorListener).start();
    }
}

