package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.store.PushBotItemStore;
import com.zoyi.channel.plugin.android.store.Store;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by jerry on 2018. 11. 23..
 */

public class PushBotSelector extends BaseSelector {

  @Nullable
  public static PushBotItem get(@Nullable String pushBotItemId) {
    return Store.getInstance(PushBotItemStore.class).get(pushBotItemId);
  }

  private static List<PushBotItem> getAllPushBotItems() {
    return Store.getInstance(PushBotItemStore.class).get();
  }

  public static List<PushBotItem> getVisiblePushBotItems() {
    List<PushBotItem> visiblePushBotItems = new ArrayList<>();

    for (PushBotItem pushBotItem : getAllPushBotItems()) {
      if (pushBotItem.shouldShowToList()) {
        visiblePushBotItems.add(pushBotItem);
      }
    }
    return visiblePushBotItems;
  }

  public static int getTotalVisiblePushBotCount() {
    int count = 0;

    for(PushBotItem pushBotItem : getVisiblePushBotItems()) {
      count += pushBotItem.getAlertCount();
    }

    return count;
  }

  public static boolean hasVisiblePushBot() {
    return getTotalVisiblePushBotCount() > 0;
  }

  public static boolean canTryReach(@Nullable String pushBotId) {
    return pushBotId != null && Store.getInstance(PushBotItemStore.class).get(pushBotId) == null;
  }
}

