package com.zoyi.channel.plugin.android.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;

public class ChannelBroadcastReceiver extends BroadcastReceiver {

  static final String ACTION_CHANNEL_PLUGIN_PUSH_CLICK = "com.zoyi.channel.plugin.android.push.CHANNEL_PUSH_CLICK";

  @Override
  public void onReceive(Context context, Intent intent) {
    switch (intent.getAction()) {
      case ACTION_CHANNEL_PLUGIN_PUSH_CLICK:
        handlePushClick(context, intent);
        break;
    }
  }

  private void handlePushClick(Context context, Intent intent) {
    Intent hostIntent = intent.getParcelableExtra(Const.EXTRA_HOST_APP_INTENT);

    if (hostIntent == null) {
      return;
    }

    String chatId = hostIntent.getStringExtra(Const.EXTRA_CHAT_ID);

    if (!TextUtils.isEmpty(chatId)) {
      PrefSupervisor.setPushChatId(context, chatId);
      context.startActivity(hostIntent);
    }
  }

}
