package com.zoyi.channel.plugin.android.activity.chat.view.action;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.model.ActionButton;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.message_format.MessageParser;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

/**
 * Created by jerry on 2018. 6. 11..
 */

public class ActionButtonView extends LinearLayout implements View.OnTouchListener {

  private Context context;

  private MaskableFrameLayout leftRoundHeaderLayout;
  private MaskableFrameLayout roundHeaderLayout;

  private View leftRoundHeader;
  private View roundHeader;
  private CHTextView buttonText;

  @Nullable
  private OnMessageContentClickListener onMessageContentClickListener;

  @NonNull
  private String actionType;
  @NonNull
  private ActionButton actionButton;

  private int COLOR_DARK_80;
  private int COLOR_WHITE;

  private boolean clicked;

  public ActionButtonView(
      Context context,
      @NonNull String actionType,
      @NonNull ActionButton actionButton,
      @Nullable OnMessageContentClickListener onMessageContentClickListener) {
    super(context);
    init(context, actionType, actionButton, onMessageContentClickListener);
  }

  @Initializer
  private void init(
      Context context,
      @NonNull String actionType,
      @NonNull ActionButton actionButton,
      @Nullable OnMessageContentClickListener onMessageContentClickListener) {
    this.context = context;
    this.actionType = actionType;
    this.actionButton = actionButton;

    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_action_button, this);

    leftRoundHeaderLayout = view.findViewById(R.id.ch_layout_form_message_head);
    roundHeaderLayout = view.findViewById(R.id.ch_layout_form_message_content);

    leftRoundHeader = view.findViewById(R.id.ch_view_form_message_head_top);
    roundHeader = view.findViewById(R.id.ch_view_form_message_content_top);

    buttonText = view.findViewById(R.id.ch_text_form_message_complete);

    leftRoundHeader.setVisibility(GONE);
    roundHeader.setVisibility(VISIBLE);

    COLOR_DARK_80 = ContextCompat.getColor(context, R.color.ch_dark_80);
    COLOR_WHITE = ContextCompat.getColor(context, R.color.ch_white);

    clicked = false;

    setButtonText(actionButton);
    setListener(onMessageContentClickListener);
    changeColor(false);
  }

  private void setButtonText(ActionButton actionButton) {
    buttonText.setMaxLines(2);
    buttonText.setEllipsize(TextUtils.TruncateAt.END);
    buttonText.setTextColor(COLOR_DARK_80);
    if (MessageParser.get() != null) {
      buttonText.setText(MessageParser.get().parse(actionButton.getValue()));
    } 
  }

  private void setListener(@Nullable OnMessageContentClickListener onMessageContentClickListener) {
    setOnTouchListener(this);
    this.onMessageContentClickListener = onMessageContentClickListener;
  }

  @Override
  public boolean onTouch(View v, MotionEvent event) {
    switch (event.getAction()) {

      case MotionEvent.ACTION_DOWN:
        changeColor(!clicked);
        break;

      case MotionEvent.ACTION_CANCEL:
        changeColor(clicked);
        break;

      case MotionEvent.ACTION_UP:
        clicked = !clicked;

        if (onMessageContentClickListener != null) {
          onMessageContentClickListener.onActionClick(actionType, actionButton);
        }
        break;
    }
    return true;
  }

  private void changeColor(boolean isClicked) {
    GradientDrawable drawable = new GradientDrawable();
    drawable.setColor(isClicked ? ColorSelector.getBackgroundColor() : COLOR_WHITE);
    drawable.setStroke((int) Utils.dpToPx(context, 1f), isClicked ? ColorSelector.getBackgroundColor() : COLOR_DARK_80);
    drawable.setCornerRadius((int) Utils.dpToPx(context, 15f));

    roundHeader.setBackgroundDrawable(drawable);
    buttonText.setBackgroundDrawable(drawable);

    buttonText.setTextColor(isClicked ? ColorSelector.getTextColor() : COLOR_DARK_80);
  }
}
