package com.zoyi.channel.plugin.android.activity.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.base.BasePresenter;
import com.zoyi.channel.plugin.android.base.BaseView;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.model.ActionButton;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;

import java.util.ArrayList;

/**
 * Created by mika on 2018. 11. 6..
 */

public interface ChatContract2 {

  interface View extends BaseView<Presenter> {
    void showInitBanner();
    void refreshChatCount(boolean force);
    void refreshMenu(boolean isLocalChat);
    void onUserChatChange(@Nullable UserChat oldUserChat, @NonNull UserChat userChat);
//    void bindUserChat(@NonNull UserChat userChat);
    void bindChannel(@NonNull Channel channel);
    void onError();
    void onTryRefresh();
    void scrollToBottom();
    void tryScrollToBottom();
    void onHostMessageArrive(Message message);
    void setInputFrameVisibility(boolean visibility);
    void setPushBotSaveButtonVisibility(boolean visible);
    void onCountriesFetch(ProfileBotMessageItem item, String key, MobileNumber mobileNumber);
  }

  interface Presenter extends BasePresenter<View> {
    void setAdapterView(ChatAdapterContract2.View adapterView);
    void setAdapterModel(ChatAdapterContract2.Model adapterModel);

    void init();
    void updateInitMessage();
    void refresh();
    void release();

    boolean isLocalChat();
    boolean hasBackwardMessages();

    void sendText(String text);
    void sendFiles(ArrayList<String> paths);
    void onActionClick(@NonNull String actionType, @NonNull ActionButton actionButton);

    void resend(SendingMessageItem item);
    void cancelSend(SendingMessageItem item);

    void fetchCountries(ProfileBotMessageItem item, String key, MobileNumber mobileNumber);
    void selectCountry(ProfileBotMessageItem item, String key, MobileNumber mobileNumber, String countryCode);
    void updateProfile(ProfileBotMessageItem item, String key, Object value);

    void translateMessage(@NonNull Message message, String targetLanguage);

    void receiveCommand(Command command, @Nullable Object object);
    void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity);
    void receiveTyping(Typing typing);

    void fetchBackwardMessages();
    void createPushBotUserChat();
  }
}
