/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ActivityLifecycleManager;
import com.zoyi.channel.plugin.android.ChannelApiManager;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.OnGuestUpdatedListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.event.BadgeBus;
import com.zoyi.channel.plugin.android.event.ChannelViewBus;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.model.etc.InAppPushItem;
import com.zoyi.channel.plugin.android.model.etc.PushEvent;
import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.wrapper.EventRepo;
import com.zoyi.channel.plugin.android.model.wrapper.GuestWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.push_bot.PushBotManager;
import com.zoyi.channel.plugin.android.selector.ChannelIOSelector;
import com.zoyi.channel.plugin.android.selector.GuestSelector;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.ObjectUtils;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.HashMap;

public class ChannelIOManager {
    @Nullable
    private static ChannelIOManager channelIOManager;
    private Application application;
    private ActivityLifecycleManager activityLifecycleManager;
    private int activityRunningCount = 0;
    @Nullable
    private Subscription socketSubscription;
    @Nullable
    private ChannelPluginListener channelPluginListener;

    static void create(Application application, ActivityLifecycleManager activityLifecycleManager) {
        if (channelIOManager == null) {
            channelIOManager = new ChannelIOManager(application, activityLifecycleManager);
        }
    }

    private ChannelIOManager(Application application, ActivityLifecycleManager activityLifecycleManager) {
        this.application = application;
        this.activityLifecycleManager = activityLifecycleManager;
    }

    static void subscribeSocket() {
        if (channelIOManager != null) {
            channelIOManager.startReceiveSocket();
        }
    }

    static void release() {
        if (channelIOManager != null) {
            channelIOManager.stopReceiveSocket();
        }
    }

    static void fetchMe(final @Nullable OnGuestUpdatedListener listener) {
        if (channelIOManager != null) {
            ChannelApiManager.get().touch().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<GuestWrapper>(){

                @Override
                public void onNext(GuestWrapper repo) {
                    if (repo != null) {
                        repo.update();
                        if (listener != null) {
                            listener.onGuestUpdated();
                        }
                    }
                }
            });
        }
    }

    private void startReceiveSocket() {
        if (this.socketSubscription == null || this.socketSubscription.isUnsubscribed()) {
            this.socketSubscription = RxBus.observable().subscribe((Action1)new Action1<Object>(){

                public void call(Object o) {
                    if (o instanceof CommandBus) {
                        CommandBus commandBus = (CommandBus)o;
                        switch (commandBus.getCommand()) {
                            case READY: {
                                ChannelIOManager.fetchMe(null);
                            }
                        }
                    }
                    if (o instanceof BadgeBus && ChannelIOManager.this.channelPluginListener != null) {
                        ChannelIOManager.this.channelPluginListener.onChangeBadge(((BadgeBus)o).getCount());
                    }
                    if (o instanceof ChannelViewBus) {
                        ChannelViewBus channelViewBus = (ChannelViewBus)o;
                        if (ChannelIOManager.this.channelPluginListener != null) {
                            switch (channelViewBus.getChannelViewEvent()) {
                                case SHOW_IN_APP_PUSH: {
                                    if (channelViewBus.getData() == null || !(channelViewBus.getData() instanceof InAppPushItem)) break;
                                    ChannelIOManager.this.channelPluginListener.onReceivePush(new PushEvent((InAppPushItem)channelViewBus.getData()));
                                    break;
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    private void stopReceiveSocket() {
        if (this.socketSubscription != null && !this.socketSubscription.isUnsubscribed()) {
            this.socketSubscription.unsubscribe();
        }
    }

    public static void increaseActivityRunningCount() {
        if (channelIOManager != null) {
            ++ChannelIOManager.channelIOManager.activityRunningCount;
        }
    }

    public static void decreaseActivityRunningCount() {
        if (channelIOManager != null) {
            --ChannelIOManager.channelIOManager.activityRunningCount;
        }
    }

    public static boolean isChannelIOActivityRunning() {
        return channelIOManager != null && ChannelIOManager.channelIOManager.activityRunningCount > 0;
    }

    @Nullable
    public static ChannelPluginListener getChannelPluginListener() {
        if (channelIOManager != null) {
            return ChannelIOManager.channelIOManager.channelPluginListener;
        }
        return null;
    }

    static void setChannelPluginListener(ChannelPluginListener channelPluginListener) {
        if (channelIOManager != null) {
            ChannelIOManager.channelIOManager.channelPluginListener = channelPluginListener;
        }
    }

    static void clearChannelPluginListener() {
        if (channelIOManager != null) {
            ChannelIOManager.channelIOManager.channelPluginListener = null;
        }
    }

    static void trackPageView(@Nullable Context context, @NonNull String pluginId) {
        HashMap<String, Object> property = new HashMap<String, Object>();
        if (context != null) {
            property.put("url", context.getClass().getSimpleName());
        }
        ChannelIOManager.track(pluginId, new Event("PageView", property));
    }

    static void track(@NonNull String pluginId, @NonNull Event event) {
        RequestBody body = RequestUtils.form().set("event", ObjectUtils.toMap(event)).set("guest", ObjectUtils.toMap(GuestSelector.get())).create();
        ChannelApiManager.call(ChannelApiManager.get().trackEvent(pluginId, body), new RestSubscriber<EventRepo>(){

            @Override
            public void onError(RetrofitException error) {
                L.e(error.getMessage());
            }

            @Override
            public void onSuccess(@NonNull EventRepo eventRepo) {
                if (ListUtils.hasItems(eventRepo.getPushBotCandidates())) {
                    PushBotManager.reachPushBots(eventRepo.getPushBotCandidates());
                }
            }
        });
    }

    public static boolean startMessenger(@Nullable Context context, @Nullable String chatId, boolean isAnimated) {
        if (!ChannelIO.isInitializedChannelIO()) {
            L.e("Fail to start messenger, please initialize ChannelIO first");
            return false;
        }
        if (!ChannelIOSelector.isBooted()) {
            L.e("Fail to start messenger, please 'Boot' first");
            return false;
        }
        if (context == null) {
            L.e("Fail to start messenger, context can't be NULL");
            return false;
        }
        if (channelIOManager != null) {
            ChannelIOManager.channelIOManager.activityLifecycleManager.finishExistChatActivity();
        }
        IntentUtils.setNextActivity(context, UserChatListActivity.class).putExtra("chatId", chatId).putExtra("animated", isAnimated).setFlag(0x4000000).setTransition(isAnimated ? Transition.SLIDE_FROM_BOTTOM : Transition.NONE).startActivity();
        return true;
    }
}

