package com.zoyi.channel.plugin.android.store;

import android.support.annotation.NonNull;

import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.ChannelIOSelector;
import com.zoyi.channel.plugin.android.util.CompareUtils;

import java.util.Collection;

/**
 * Created by mika on 2018. 6. 18..
 */

public class UserChatStore extends RecordUpdatesCollectionStore<UserChat> implements DestroyableStore {

  private boolean canUpdate = false;

  @NonNull
  @Override
  protected StoreType getStoreType() {
    return StoreType.USER_CHAT;
  }

  @Override
  protected boolean canUpdate(UserChat oldbie, UserChat newbie) {
    return super.canUpdate(oldbie, newbie) && canUpdate;
  }

  @Override
  public synchronized void set(Collection<UserChat> list) {
    canUpdate = true;
    super.set(list);
  }

  public void setCanUpdate(boolean canUpdate) {
    this.canUpdate = canUpdate;
  }

  @Override
  protected void updated(UserChat userChat) {
    if (userChat != null) {
      if (CompareUtils.exists(userChat.getState(), Store.getInstance(ChannelIOSettingsStore.class).getBlockFilters())) {
        removed(userChat);
      } else {
        super.updated(userChat);
      }
    }
  }

  @Override
  public void clearData() {
    map.clear();
    canUpdate = false;
  }
}
