package com.zoyi.channel.plugin.android.store;

import android.support.annotation.NonNull;

import com.zoyi.channel.plugin.android.enumerate.StoreType;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by mika on 2018. 6. 18..
 */

public abstract class Store {

  private static final Map<Class<? extends Store>, Store> instances = new HashMap<>();

  @NonNull
  public static <T extends Store> T getInstance(Class<T> clazz) {
    if (instances.get(clazz) == null) {
      synchronized (instances) {
        if (instances.get(clazz) == null) {
          try {
            instances.put(clazz, clazz.newInstance());
          } catch (InstantiationException e) {
            e.printStackTrace();
          } catch (IllegalAccessException e) {
            e.printStackTrace();
          }
        }
      }
    }
    return (T) instances.get(clazz);
  }

  public static void destroy() {
    synchronized (instances) {
      for (Store store : instances.values()) {
        if (store != null && store instanceof DestroyableStore) {
          ((DestroyableStore) store).clearData();
        }
      }
    }
  }

  protected abstract StoreType getStoreType();
}
