/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.store;

import android.support.annotation.NonNull;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store.ChannelIOSettingsStore;
import com.zoyi.channel.plugin.android.store.DestroyableStore;
import com.zoyi.channel.plugin.android.store.RecordUpdatesCollectionStore;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import java.util.Collection;

public class UserChatStore
extends RecordUpdatesCollectionStore<UserChat>
implements DestroyableStore {
    private boolean canUpdate = false;

    @Override
    @NonNull
    protected StoreType getStoreType() {
        return StoreType.USER_CHAT;
    }

    @Override
    protected boolean canUpdate(UserChat oldbie, UserChat newbie) {
        return super.canUpdate(oldbie, newbie) && this.canUpdate;
    }

    @Override
    public synchronized void set(Collection<UserChat> list) {
        this.canUpdate = true;
        super.set(list);
    }

    public void setCanUpdate(boolean canUpdate) {
        this.canUpdate = canUpdate;
    }

    @Override
    protected void updated(UserChat userChat) {
        if (userChat != null) {
            if (CompareUtils.exists((Comparable)((Object)userChat.getState()), (Comparable[])Store.getInstance(ChannelIOSettingsStore.class).getBlockFilters())) {
                this.removed(userChat);
            } else {
                super.updated(userChat);
            }
        }
    }

    @Override
    public void clearData() {
        this.map.clear();
        this.canUpdate = false;
    }
}

