package com.zoyi.channel.plugin.android.push_bot;

import android.support.annotation.NonNull;

import com.zoyi.channel.plugin.android.ChannelApiManager;
import com.zoyi.channel.plugin.android.enumerate.ChannelViewEvent;
import com.zoyi.channel.plugin.android.evaluation.EnvironmentInfo;
import com.zoyi.channel.plugin.android.evaluation.EvaluationUtils;
import com.zoyi.channel.plugin.android.event.ChannelViewBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.ApiTag;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.rest.PushBot;
import com.zoyi.channel.plugin.android.model.wrapper.PushBotReachRepo;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.selector.PushBotSelector;
import com.zoyi.channel.plugin.android.store.PushBotItemStore;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.rx.Observable;
import com.zoyi.rx.functions.Func1;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Created by jerry on 2018. 11. 9..
 */

public class PushBotManager {

  public static void evaluatePushBots(List<PushBot> pushBots, final EnvironmentInfo environmentInfo) {

    ChannelApiManager.call(
        Observable.from(pushBots)
            .filter(new Func1<PushBot, Boolean>() { // Check whether push bot has already been tried reach.
              @Override
              public Boolean call(PushBot pushBot) {
                return PushBotSelector.canTryReach(pushBot.getId());
              }
            })
            .filter(new Func1<PushBot, Boolean>() { // Evaluate push bot
              @Override
              public Boolean call(PushBot pushBot) {
                return EvaluationUtils.evaluateTarget(pushBot.getTarget(), environmentInfo);
              }
            })
            .toList() // Collect push bot to try reach
            .flatMap(new Func1<List<PushBot>, Observable<PushBot>>() {
              @Override
              public Observable<PushBot> call(List<PushBot> pushBots) {
                return Observable.from(pushBots);
              }
            })
            .flatMap(new Func1<PushBot, Observable<PushBot>>() { // wait delay
              @Override
              public Observable<PushBot> call(PushBot pushBot) {
                return Observable.just(pushBot).delay(pushBot.getTriggerDelay(), TimeUnit.SECONDS);
              }
            })
            .filter(new Func1<PushBot, Boolean>() { // Check whether push bot has already been tried reach.
              @Override
              public Boolean call(PushBot pushBot) {
                return PushBotSelector.canTryReach(pushBot.getId());
              }
            })
            .concatMap(new Func1<PushBot, Observable<PushBotReachRepo>>() { // try reach
              @Override
              public Observable<PushBotReachRepo> call(PushBot pushBot) {
                return ChannelApiManager.get().reachPushBot(pushBot.getId());
              }
            })
            .filter(new Func1<PushBotReachRepo, Boolean>() {
              @Override
              public Boolean call(PushBotReachRepo pushBotReachRepo) {
                return pushBotReachRepo.isReach();
              }
            })
            .first(),

        new RestSubscriber<PushBotReachRepo>() {
          @Override
          public void onError(RetrofitException error) {
            L.e("Fail to show push bot. " + error.getMessage());
          }

          @Override
          public void onSuccess(@NonNull PushBotReachRepo pushBotReachRepo) {
            if (pushBotReachRepo.isValid()) {
              PushBotItem pushBotItem = PushBotItem.newInstance(pushBotReachRepo.getPushBot(), pushBotReachRepo.getPushBotVariant());
              Store.getInstance(PushBotItemStore.class).add(pushBotItem);

              if (!pushBotReachRepo.isOriginState()) {
                pushBotReachRepo.set();
                RxBus.post(new ChannelViewBus(ChannelViewEvent.SHOW_PUSH_BOT, pushBotItem));
              }
            }
          }
        });
  }
}
