package com.zoyi.channel.plugin.android.activity.userchat_list.contract;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.userchat_list.listener.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.ChatListItem;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.ChatListItemType;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.UserChatItem;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;

import java.util.List;

public interface UserChatAdapterContract {

  interface View {

    void setOnUserChatClickListener(OnUserChatClickListener clickListener);

    void notifyDataSetChanged();
  }

  interface Model {

    @Nullable
    ChatListItem getFirstChatListItem();
    @Nullable
    ChatListItem getUserChatItem(@NonNull String id);

    void setUserChats(List<UserChat> userChats);

    void upsertUserChat(@NonNull UserChat userChat);
    void upsertPushBotItem(@NonNull PushBotItem pushBotItem);
    void removeUserChat(@NonNull String chatId);
    void removePushBotItem(@NonNull PushBotItem pushBotItem);

    void updateManager(String managerId);
    void updateSession(@NonNull Session session);
  }

}
