/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Single;
import com.zoyi.rx.SingleSubscriber;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SingleTimeout<T>
implements Single.OnSubscribe<T> {
    final Single.OnSubscribe<T> source;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Single.OnSubscribe<? extends T> other;

    public SingleTimeout(Single.OnSubscribe<T> source, long timeout, TimeUnit unit, Scheduler scheduler, Single.OnSubscribe<? extends T> other) {
        this.source = source;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.other = other;
    }

    @Override
    public void call(SingleSubscriber<? super T> t) {
        TimeoutSingleSubscriber<T> parent = new TimeoutSingleSubscriber<T>(t, this.other);
        Scheduler.Worker w = this.scheduler.createWorker();
        parent.add(w);
        t.add(parent);
        w.schedule(parent, this.timeout, this.unit);
        this.source.call(parent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TimeoutSingleSubscriber<T>
    extends SingleSubscriber<T>
    implements Action0 {
        final SingleSubscriber<? super T> actual;
        final AtomicBoolean once;
        final Single.OnSubscribe<? extends T> other;

        TimeoutSingleSubscriber(SingleSubscriber<? super T> actual, Single.OnSubscribe<? extends T> other) {
            this.actual = actual;
            this.other = other;
            this.once = new AtomicBoolean();
        }

        @Override
        public void onSuccess(T value) {
            if (this.once.compareAndSet(false, true)) {
                try {
                    this.actual.onSuccess(value);
                }
                finally {
                    this.unsubscribe();
                }
            }
        }

        @Override
        public void onError(Throwable error) {
            if (this.once.compareAndSet(false, true)) {
                try {
                    this.actual.onError(error);
                }
                finally {
                    this.unsubscribe();
                }
            } else {
                RxJavaHooks.onError(error);
            }
        }

        @Override
        public void call() {
            if (this.once.compareAndSet(false, true)) {
                try {
                    Single.OnSubscribe<OtherSubscriber<? super T>> o = this.other;
                    if (o == null) {
                        this.actual.onError(new TimeoutException());
                    } else {
                        OtherSubscriber<? super T> p = new OtherSubscriber<T>(this.actual);
                        this.actual.add(p);
                        o.call(p);
                    }
                }
                finally {
                    this.unsubscribe();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class OtherSubscriber<T>
        extends SingleSubscriber<T> {
            final SingleSubscriber<? super T> actual;

            OtherSubscriber(SingleSubscriber<? super T> actual) {
                this.actual = actual;
            }

            @Override
            public void onSuccess(T value) {
                this.actual.onSuccess(value);
            }

            @Override
            public void onError(Throwable error) {
                this.actual.onError(error);
            }
        }
    }
}

