/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Completable;
import com.zoyi.rx.CompletableSubscriber;
import com.zoyi.rx.Single;
import com.zoyi.rx.SingleSubscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SingleTakeUntilCompletable<T>
implements Single.OnSubscribe<T> {
    final Single.OnSubscribe<T> source;
    final Completable other;

    public SingleTakeUntilCompletable(Single.OnSubscribe<T> source, Completable other) {
        this.source = source;
        this.other = other;
    }

    @Override
    public void call(SingleSubscriber<? super T> t) {
        TakeUntilSourceSubscriber<? super T> parent = new TakeUntilSourceSubscriber<T>(t);
        t.add(parent);
        this.other.subscribe(parent);
        this.source.call(parent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TakeUntilSourceSubscriber<T>
    extends SingleSubscriber<T>
    implements CompletableSubscriber {
        final SingleSubscriber<? super T> actual;
        final AtomicBoolean once;

        TakeUntilSourceSubscriber(SingleSubscriber<? super T> actual) {
            this.actual = actual;
            this.once = new AtomicBoolean();
        }

        @Override
        public void onSubscribe(Subscription d) {
            this.add(d);
        }

        @Override
        public void onSuccess(T value) {
            if (this.once.compareAndSet(false, true)) {
                this.unsubscribe();
                this.actual.onSuccess(value);
            }
        }

        @Override
        public void onError(Throwable error) {
            if (this.once.compareAndSet(false, true)) {
                this.unsubscribe();
                this.actual.onError(error);
            } else {
                RxJavaHooks.onError(error);
            }
        }

        @Override
        public void onCompleted() {
            this.onError(new CancellationException("Single::takeUntil(Completable) - Stream was canceled before emitting a terminal event."));
        }
    }
}

