/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;

public class MaskableFrameLayout
extends FrameLayout {
    private static final String TAG = "MaskableFrameLayout";
    private static final int MODE_ADD = 0;
    private static final int MODE_CLEAR = 1;
    private static final int MODE_DARKEN = 2;
    private static final int MODE_DST = 3;
    private static final int MODE_DST_ATOP = 4;
    private static final int MODE_DST_IN = 5;
    private static final int MODE_DST_OUT = 6;
    private static final int MODE_DST_OVER = 7;
    private static final int MODE_LIGHTEN = 8;
    private static final int MODE_MULTIPLY = 9;
    private static final int MODE_OVERLAY = 10;
    private static final int MODE_SCREEN = 11;
    private static final int MODE_SRC = 12;
    private static final int MODE_SRC_ATOP = 13;
    private static final int MODE_SRC_IN = 14;
    private static final int MODE_SRC_OUT = 15;
    private static final int MODE_SRC_OVER = 16;
    private static final int MODE_XOR = 17;
    @Nullable
    private Handler mHandler;
    @Nullable
    private Drawable mDrawableMask = null;
    @Nullable
    private Bitmap mFinalMask = null;
    private boolean mAntiAliasing = false;
    @Nullable
    private Paint mPaint = null;
    @Nullable
    private PorterDuffXfermode mPorterDuffXferMode = null;

    public MaskableFrameLayout(Context context) {
        super(context);
    }

    public MaskableFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.construct(context, attrs);
    }

    public MaskableFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.construct(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void construct(Context context, AttributeSet attrs) {
        this.mHandler = new Handler();
        this.setDrawingCacheEnabled(true);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        this.mPaint = this.createPaint(false);
        theme = context.getTheme();
        if (theme != null) {
            a = theme.obtainStyledAttributes(attrs, R.styleable.MaskableLayout, 0, 0);
            try {
                this.initMask(this.loadMask(a));
                this.mPorterDuffXferMode = this.getModeFromInteger(a.getInteger(R.styleable.MaskableLayout_ch_porterduffxfermode, 0));
                this.initMask(this.mDrawableMask);
                if (!a.getBoolean(R.styleable.MaskableLayout_ch_anti_aliasing, false)) ** GOTO lbl21
                this.mPaint = this.createPaint(true);
            }
            finally {
                if (a != null) {
                    a.recycle();
                }
            }
        } else {
            this.log("Couldn't load theme, mask in xml won't be loaded.");
        }
lbl21:
        // 3 sources

        this.registerMeasure();
    }

    private Paint createPaint(boolean antiAliasing) {
        Paint output = new Paint(1);
        output.setAntiAlias(antiAliasing);
        output.setXfermode((Xfermode)this.mPorterDuffXferMode);
        return output;
    }

    private Drawable loadMask(TypedArray a) {
        return a.getDrawable(R.styleable.MaskableLayout_ch_mask);
    }

    private void initMask(@Nullable Drawable input) {
        if (input != null) {
            this.mDrawableMask = input;
            if (this.mDrawableMask instanceof AnimationDrawable) {
                this.mDrawableMask.setCallback((Drawable.Callback)this);
            }
        } else {
            this.log("Are you sure you don't want to provide a mask ?");
        }
    }

    @Nullable
    public Drawable getDrawableMask() {
        return this.mDrawableMask;
    }

    @Nullable
    private Bitmap makeBitmapMask(@Nullable Drawable drawable2) {
        if (drawable2 != null) {
            if (this.getMeasuredWidth() > 0 && this.getMeasuredHeight() > 0) {
                Bitmap mask = Bitmap.createBitmap((int)this.getMeasuredWidth(), (int)this.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(mask);
                drawable2.setBounds(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
                drawable2.draw(canvas);
                return mask;
            }
            this.log("Can't create a mask with height 0 or width 0. Or the layout has no children and is wrap content");
            return null;
        }
        this.log("No bitmap mask loaded, view will NOT be masked !");
        return null;
    }

    public void setMask(int drawableRes) {
        Resources res = this.getResources();
        if (res != null) {
            this.setMask(res.getDrawable(drawableRes));
        } else {
            this.log("Unable to load resources, mask will not be loaded as drawable");
        }
    }

    public void setMask(Drawable input) {
        this.initMask(input);
        this.swapBitmapMask(this.makeBitmapMask(this.mDrawableMask));
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.setSize(w, h);
    }

    private void setSize(int width, int height) {
        if (width > 0 && height > 0) {
            if (this.mDrawableMask != null) {
                this.swapBitmapMask(this.makeBitmapMask(this.mDrawableMask));
            }
        } else {
            this.log("Width and height must be higher than 0");
        }
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mFinalMask != null && this.mPaint != null) {
            this.mPaint.setXfermode((Xfermode)this.mPorterDuffXferMode);
            canvas.drawBitmap(this.mFinalMask, 0.0f, 0.0f, this.mPaint);
            this.mPaint.setXfermode(null);
        } else {
            this.log("Mask or paint is null ...");
        }
    }

    private void registerMeasure() {
        final ViewTreeObserver treeObserver = this.getViewTreeObserver();
        if (treeObserver != null && treeObserver.isAlive()) {
            treeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    ViewTreeObserver aliveObserver = treeObserver;
                    if (!aliveObserver.isAlive()) {
                        aliveObserver = MaskableFrameLayout.this.getViewTreeObserver();
                    }
                    if (aliveObserver != null) {
                        if (Build.VERSION.SDK_INT >= 16) {
                            aliveObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            aliveObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                    } else {
                        MaskableFrameLayout.this.log("GlobalLayoutListener not removed as ViewTreeObserver is not valid");
                    }
                    MaskableFrameLayout.this.swapBitmapMask(MaskableFrameLayout.this.makeBitmapMask(MaskableFrameLayout.this.mDrawableMask));
                }
            });
        }
    }

    private void log(String message) {
    }

    public void invalidateDrawable(@Nullable Drawable dr) {
        if (dr != null) {
            this.initMask(dr);
            this.swapBitmapMask(this.makeBitmapMask(dr));
            this.invalidate();
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        if (who != null && what != null && this.mHandler != null) {
            this.mHandler.postAtTime(what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        if (who != null && what != null && this.mHandler != null) {
            this.mHandler.removeCallbacks(what);
        }
    }

    private void swapBitmapMask(@Nullable Bitmap newMask) {
        if (newMask != null) {
            if (this.mFinalMask != null && !this.mFinalMask.isRecycled()) {
                this.mFinalMask.recycle();
            }
            this.mFinalMask = newMask;
        }
    }

    private PorterDuffXfermode getModeFromInteger(int index) {
        PorterDuff.Mode mode;
        switch (index) {
            case 0: {
                PorterDuff.Mode mode2 = PorterDuff.Mode.ADD;
            }
            case 1: {
                mode = PorterDuff.Mode.CLEAR;
                break;
            }
            case 2: {
                mode = PorterDuff.Mode.DARKEN;
                break;
            }
            case 3: {
                mode = PorterDuff.Mode.DST;
                break;
            }
            case 4: {
                mode = PorterDuff.Mode.DST_ATOP;
                break;
            }
            case 5: {
                mode = PorterDuff.Mode.DST_IN;
                break;
            }
            case 6: {
                mode = PorterDuff.Mode.DST_OUT;
                break;
            }
            case 7: {
                mode = PorterDuff.Mode.DST_OVER;
                break;
            }
            case 8: {
                mode = PorterDuff.Mode.LIGHTEN;
                break;
            }
            case 9: {
                mode = PorterDuff.Mode.MULTIPLY;
                break;
            }
            case 10: {
                mode = PorterDuff.Mode.OVERLAY;
            }
            case 11: {
                mode = PorterDuff.Mode.SCREEN;
                break;
            }
            case 12: {
                mode = PorterDuff.Mode.SRC;
                break;
            }
            case 13: {
                mode = PorterDuff.Mode.SRC_ATOP;
                break;
            }
            case 14: {
                mode = PorterDuff.Mode.SRC_IN;
                break;
            }
            case 15: {
                mode = PorterDuff.Mode.SRC_OUT;
                break;
            }
            case 16: {
                mode = PorterDuff.Mode.SRC_OVER;
                break;
            }
            case 17: {
                mode = PorterDuff.Mode.XOR;
                break;
            }
            default: {
                mode = PorterDuff.Mode.DST_IN;
            }
        }
        return new PorterDuffXfermode(mode);
    }
}

