/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.action;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.model.ActionButton;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.message_format.MessageParser;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

public class ActionButtonView
extends LinearLayout
implements View.OnTouchListener {
    private Context context;
    private MaskableFrameLayout leftRoundHeaderLayout;
    private MaskableFrameLayout roundHeaderLayout;
    private View leftRoundHeader;
    private View roundHeader;
    private CHTextView buttonText;
    @Nullable
    private OnMessageContentClickListener onMessageContentClickListener;
    @NonNull
    private String actionType;
    @NonNull
    private ActionButton actionButton;
    private int COLOR_DARK_80;
    private int COLOR_WHITE;
    private boolean clicked;

    public ActionButtonView(Context context, @NonNull String actionType, @NonNull ActionButton actionButton, @Nullable OnMessageContentClickListener onMessageContentClickListener) {
        super(context);
        this.init(context, actionType, actionButton, onMessageContentClickListener);
    }

    @Initializer
    private void init(Context context, @NonNull String actionType, @NonNull ActionButton actionButton, @Nullable OnMessageContentClickListener onMessageContentClickListener) {
        this.context = context;
        this.actionType = actionType;
        this.actionButton = actionButton;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_action_button, (ViewGroup)this);
        this.leftRoundHeaderLayout = (MaskableFrameLayout)view.findViewById(R.id.ch_layout_form_message_head);
        this.roundHeaderLayout = (MaskableFrameLayout)view.findViewById(R.id.ch_layout_form_message_content);
        this.leftRoundHeader = view.findViewById(R.id.ch_view_form_message_head_top);
        this.roundHeader = view.findViewById(R.id.ch_view_form_message_content_top);
        this.buttonText = (CHTextView)view.findViewById(R.id.ch_text_form_message_complete);
        this.leftRoundHeader.setVisibility(8);
        this.roundHeader.setVisibility(0);
        this.COLOR_DARK_80 = ContextCompat.getColor((Context)context, (int)R.color.ch_dark_80);
        this.COLOR_WHITE = ContextCompat.getColor((Context)context, (int)R.color.ch_white);
        this.clicked = false;
        this.setButtonText(actionButton);
        this.setListener(onMessageContentClickListener);
        this.changeColor(false);
    }

    private void setButtonText(ActionButton actionButton) {
        this.buttonText.setMaxLines(2);
        this.buttonText.setEllipsize(TextUtils.TruncateAt.END);
        this.buttonText.setTextColor(this.COLOR_DARK_80);
        if (MessageParser.get() != null) {
            this.buttonText.setText((CharSequence)MessageParser.get().parse(actionButton.getValue()));
        }
    }

    private void setListener(@Nullable OnMessageContentClickListener onMessageContentClickListener) {
        this.setOnTouchListener(this);
        this.onMessageContentClickListener = onMessageContentClickListener;
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.changeColor(!this.clicked);
                break;
            }
            case 3: {
                this.changeColor(this.clicked);
                break;
            }
            case 1: {
                boolean bl = this.clicked = !this.clicked;
                if (this.onMessageContentClickListener == null) break;
                this.onMessageContentClickListener.onActionClick(this.actionType, this.actionButton);
            }
        }
        return true;
    }

    private void changeColor(boolean isClicked) {
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setColor(isClicked ? ColorSelector.getBackgroundColor() : this.COLOR_WHITE);
        drawable2.setStroke((int)Utils.dpToPx(this.context, 1.0f), isClicked ? ColorSelector.getBackgroundColor() : this.COLOR_DARK_80);
        drawable2.setCornerRadius((float)((int)Utils.dpToPx(this.context, 15.0f)));
        this.roundHeader.setBackgroundDrawable((Drawable)drawable2);
        this.buttonText.setBackgroundDrawable((Drawable)drawable2);
        this.buttonText.setTextColor(isClicked ? ColorSelector.getTextColor() : this.COLOR_DARK_80);
    }
}

